% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODataQualityLogicalConsistency.R
\docType{class}
\name{ISOConceptualConsistency}
\alias{ISOConceptualConsistency}
\title{ISOConceptualConsistency}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOConceptualConsistency
}
\description{
ISOConceptualConsistency
}
\section{Inherited methods}{

from \code{\link{ISODataQualityAbstractElement}}
}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOConceptualConsistency}}
 }
}
}

\examples{
  #encoding
  dq <- ISOConceptualConsistency$new()
  dq$addNameOfMeasure("measure")
  metaId <- ISOMetaIdentifier$new(code = "measure-id")
  dq$setMeasureIdentification(metaId)
  dq$setMeasureDescription("description")
  dq$setEvaluationMethodDescription("method description")
  dq$setEvaluationMethodType("indirect")
  dq$setDateTime(ISOdate(2015,1,1,12,10,49))
  spec <- ISOCitation$new()
  spec$setTitle("specification title")
  spec$addAlternateTitle("specification alternate title")
  d <- ISODate$new()
  d$setDate(ISOdate(2015, 1, 1, 1))
  d$setDateType("publication")
  spec$addDate(d)
  dq$setEvaluationProcedure(spec)
  result <- ISOConformanceResult$new()
  result$setSpecification(spec)
  result$setExplanation("some explanation about the conformance")
  result$setPass(TRUE)
  dq$addResult(result)
  xml <- dq$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{conceptual}
\keyword{consistency}
\keyword{data}
\keyword{quality}
