% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOAbstractAggregate.R
\docType{class}
\name{ISOAbstractAggregate}
\alias{ISOAbstractAggregate}
\title{ISOAbstractAggregate}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOAbstractAggregate
}
\description{
ISOAbstractAggregate
}
\note{
abstract class
}
\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an ISOAbstractAggregate
 }
 \item{\code{addComposedOf(composedOf)}}{
   Adds a dataset, object of class \code{ISODataSet}
 }
 \item{\code{delComposedOf(composedOf)}}{
   Deletes a dataset, object of class \code{ISODataSet}
 }
 \item{\code{addSeriesMetadata(metadata)}}{
   Adds a series metadata, object of class \code{ISOMetadata}
 }
 \item{\code{delSeriesMetadata(metadata)}}{
   Deletes a series metadata, object of class \code{ISOMetadata}
 }
 \item{\code{addSubset(subset)}}{
   Adds a subset, object that inherits from \code{ISOAbstractAggregate}
 }
 \item{\code{delSubset(subset)}}{
   Deletes a subset, object that inherits from \code{ISOAbstractAggregate}
 }
 \item{\code{addSuperset(superset)}}{
   Adds a superset, object that inherits from \code{ISOAbstractAggregate}
 }
 \item{\code{delSuperset(superset)}}{
   Deletes a superset, object that inherits from \code{ISOAbstractAggregate}
 }
}
}

\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{abstract}
\keyword{aggregate}
