% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryCoverageResult.R
\docType{class}
\name{ISOImageryCoverageResult}
\alias{ISOImageryCoverageResult}
\title{ISOImageryCoverageResult}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery coverage result
}
\description{
ISOImageryCoverageResult
}
\section{Fields}{

\describe{
\item{\code{spatialRepresentationType}}{[\code{\link{ISOSpatialRepresentationType}}]}

\item{\code{resultFile}}{[\code{\link{ISODataFile}}]}

\item{\code{resultSpatialRepresentation}}{[\code{\link{ISOSpatialRepresentation}}]}

\item{\code{resultContentDescription}}{[\code{\link{ISOCoverageDescription}}]}

\item{\code{resultFormat}}{[\code{\link{ISOFormat}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryCoverageResult}}
 }
 \item{\code{setSpatialRepresentationType(spatialRepresentationType)}}{
   Set the spatial representation type, object of class \code{\link{ISOSpatialRepresentationType}},
   or 'character' among values given by \code{ISOSpatialRepresentationType$values()} or any free text.
 }
 \item{\code{setResultFile(resultFile)}}{
   Set the result data file, object of class \code{\link{ISODataFile}}.
 }
 \item{\code{setResultSpatialRepresentation(spatialRepresentation)}}{
   Set the spatial representation, object of class \code{\link{ISOSpatialRepresentation}}.
 }
 \item{\code{setResultCoverageDescription(coverageDescription)}}{
   Set the coverage description, object of class \code{\link{ISOCoverageDescription}}
 }
 \item{\code{setResultFormat(format)}}{
   Set the result format, object of class \code{\link{ISOFormat}}
 }
}
}

\section{Methods inherited from \code{\link{ISOAbstractResult}}}{

See methods description at \code{\link{ISOAbstractResult}}
}

\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{coverage}
\keyword{imagery}
\keyword{result}
