% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_filter.R
\name{gt_filter}
\alias{gt_filter}
\title{Subset a geometric object using column values}
\usage{
gt_filter(obj, ..., update = TRUE)
}
\arguments{
\item{obj}{[\code{geometric object(1)}]\cr the object to derive a subset
from.}

\item{...}{subset based on logical predicates defined in terms of the columns
in \code{x} (of both, points, features and groups). Multiple conditions are
combined with \code{&}. Only rows where the condition evaluates to TRUE are
kept.}

\item{update}{[\code{logical(1)}]\cr whether or not to update the window slot
after deriving the subset.}
}
\value{
\code{geom} of the subset of \code{obj}.
}
\description{
This function allows to subset any geometric object for which all required
getters are available.
}
\examples{
# get a subset of a geom
gt_filter(gtGeoms$point, y < -10)

# get a subset of an sf-object
gt_filter(obj = gtSF$multilinestring, a == 1)
}
\seealso{
Other geometry tools: 
\code{\link{gt_locate}()},
\code{\link{gt_pull}()},
\code{\link{gt_reflect}()},
\code{\link{gt_rotate}()},
\code{\link{gt_scale}()},
\code{\link{gt_skew}()},
\code{\link{gt_stretch}()},
\code{\link{gt_translate}()}
}
\concept{geometry tools}
