% Generated by roxygen2 (4.0.2): do not edit by hand
\name{polyarea}
\alias{polyarea}
\title{Determines area of a polygon by triangle method.}
\usage{
polyarea(x, y, d = 1)
}
\arguments{
\item{x}{X coordinates of verticies.}

\item{y}{Y coordinates of verticies.}

\item{d}{Dimension of array to work along.}
}
\value{
Area(s) of polygon(s).
}
\description{
Determines area of a polygon by triangle method.  The variables
\code{x} and \code{y} define the vertex pairs, and must therefore
have the same shape.  They can be either vectors or arrays.  If
they are arrays then the columns of \code{x} and \code{y} are
treated separately and an area returned for each.
}
\details{
If the optional \code{dim} argument is given, then \code{polyarea}
works along this dimension of the arrays \code{x} and \code{y}.
}
\examples{
x <- c(1, 1, 3, 3, 1)
y <- c(1, 3, 3, 1, 1)
polyarea(x, y)
polyarea(cbind(x, x), cbind(y, y)) ##  c(4, 4)
polyarea(cbind(x, x), cbind(y,y), 1) ##  c(4, 4)
polyarea(rbind(x, x), rbind(y,y), 2) ##  c(4, 4)
}
\author{
David Sterratt based on the octave sources by David M. Doolin
}

