\name{plotAllSpecimens}
\alias{plotAllSpecimens}
\title{Plot landmark coordinates for all specimens}
\usage{
plotAllSpecimens(A, mean = TRUE, links = NULL, pointscale = 1,
  meansize = 2)
}
\arguments{
  \item{A}{An array (p x k x n) containing GPA-aligned
  coordinates for a set of specimens}

  \item{mean}{A logical value indicating whether the mean
  shape should be included in the plot}

  \item{links}{An optional matrix defining for links
  between landmarks}

  \item{pointscale}{An optional value defining the size of
  the points for all specimens}

  \item{meansize}{An optional value defining the size of
  the points representing the average specimen}
}
\description{
Function plots landmark coordinates for a set of specimens
}
\details{
The function creates a plot of the landmark coordinates for
all specimens. This is useful for examining patterns of
shape variation after GPA. If "mean=TRUE", the mean shape
will be calculated and added to the plot.  Additionally, if
a matrix of links is provided, the landmarks of the mean
shape will be connected by lines.  The link matrix is an m
x 2 matrix, where m is the desired number of links. Each
row of the link matrix designates the two landmarks to be
connected by that link. The function will plot either two-
or three-dimensional data.
}
\examples{
data(plethodon)
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment

plotAllSpecimens(Y.gpa$coords,links=plethodon$links)
}
\author{
Dean Adams
}
\keyword{visualization}

