% Generated by roxygen2 (4.0.1): do not edit by hand
\name{phylo.pls}
\alias{phylo.pls}
\title{Quantify phylogenetic morphological integration between two sets of variables}
\usage{
phylo.pls(A1, A2, phy, warpgrids = TRUE, iter = 999, label = NULL,
  verbose = FALSE)
}
\arguments{
\item{A1}{A 2D array (n x [p1 x k1]) or 3D array (p1 x k1 x n) containing landmark coordinates for the first block}

\item{A2}{A 2D array (n x [p2 x k2]) or 3D array (p2 x k2 x n) containing landmark coordinates for the second block}

\item{phy}{A phylogenetic tree of {class phylo} - see \code{\link[ape]{read.tree}} in library ape}

\item{warpgrids}{A logical value indicating whether deformation grids for shapes along PC1 should be displayed
(only relevant if data for A1 or A2 [or both] were input as 3D array)}

\item{iter}{Number of iterations for significance testing}

\item{label}{An optional vector indicating labels for each specimen that are to be displayed}

\item{verbose}{A logical value indicating whether the output is basic or verbose (see Value below)}
}
\value{
Function returns a list with the following components:
  \item{PLS Correlation}{The estimate of phylogenetic morphological covariation}
  \item{pvalue}{The significance level of the observed signal}
  \item{Block 1 PLS Scores}{PLS scores for the first block of landmarks (when {verbose=TRUE})}
  \item{Block 2 PLS Scores}{PLS scores for the second block of landmarks (when {verbose=TRUE})}
}
\description{
Function quantifies the degree of phylogenetic morphological covariation between two sets of
Procrustes-aligned coordinates using partial least squares.
}
\details{
The function quantifies the degree of phylogenetic morphological integration between two sets of shape data as
  defined by landmark coordinates. It is assumed that the landmarks have previously been aligned using
  Generalized Procrustes Analysis (GPA) [e.g., with \code{\link{gpagen}}].

The function estimates the degree of  morphological covariation between two sets of variables
while accounting for phylogeny using partial least squares (Adams and Felice 2014). The observed value is statistically assessed
using permutation, where data for one block are permuted across the tips of the phylogeny,
an estimate of the covariation between sets of variables, and compared to the observed value.

A plot of PLS scores from Block1 versus Block2 is provided for the first set of PLS axes. Thin-plate spline
  deformation grids along these axes are also shown (if data were input as a 3D array).
}
\examples{
data(plethspecies)
Y.gpa<-gpagen(plethspecies$land)    #GPA-alignment

phylo.pls(Y.gpa$coords[1:5,,],Y.gpa$coords[6:11,,],plethspecies$phy,iter=5)
}
\author{
Dean Adams
}
\references{
Adams, D.C. and R. Felice. 2014. Assessing phylogenetic morphological
integration and trait covariation in morphometric data using evolutionary covariance
matrices. PLOS ONE. 9(4):e94335.
}
\keyword{analysis}

