% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ggplot.r
\name{make_ggplot}
\alias{make_ggplot}
\title{Convert geomorph plots to ggplot objects}
\usage{
make_ggplot(object)
}
\arguments{
\item{object}{A plot object produced from \code{\link{plot.gm.prcomp}}, 
\code{\link{plot.pls}},\code{\link{plot.procD.lm}}, or \code{\link{plotAllometry}}.
For \code{\link{plot.procD.lm}} objects, only types "PC" or "regression"
should work.}
}
\description{
Function attempts to coerce plot information from a geomorph plot object to an 
amenable ggplot object.
}
\details{
This function will attempt to use the plot arguments from an geomorph plot object 
to make a ggplot that can be additionally updated, as desired.  Not all plot 
characteristics might be converted.  Nonetheless, a ggplot will be coerced and could
be updated, according to user preference.

This function assumes no responsibility for arguments made by \code{\link{ggplot}}.
It merely produces a ggplot object that should resemble a geomorph plot default.  Any 
augmentation of ggplot objects can be done either by direct intervention of the ggplot 
produced or reformatting the initial geomorph plot produced.  One should not expect direct
correspondence between R base plot parameters and ggplot parameters.
}
\examples{

### PLS Example
data(plethodon) 
Y.gpa<-gpagen(plethodon$land)    #GPA-alignment    
# landmarks on the skull and mandible assigned to partitions
land.gps<-c("A","A","A","A","A","B","B","B","B","B","B","B") 
IT <- integration.test(Y.gpa$coords, partition.gp=land.gps, iter=999)
summary(IT) # Test summary
P <- plot(IT) # PLS plot
make_ggplot(P) # same plot in ggplot

### Allometry example

data(plethodon) 
Y.gpa <- gpagen(plethodon$land, print.progress = FALSE)    #GPA-alignment  

gdf <- geomorph.data.frame(Y.gpa, site = plethodon$site, 
                          species = plethodon$species) 

fit <- procD.lm(coords ~ Csize * species * site, data=gdf, iter=0, 
                print.progress = FALSE)

P <- plotAllometry(fit, size = gdf$Csize, logsz = TRUE, method = "PredLine", 
                   pch = 19, col = as.numeric(interaction(gdf$species, gdf$site)))

make_ggplot(P)

### Tangent Space plot

data(plethspecies) 
Y.gpa <- gpagen(plethspecies$land)    #GPA-alignment

PCA.w.phylo <- gm.prcomp(Y.gpa$coords, phy = plethspecies$phy)
P <- plot(PCA.w.phylo, phylo = TRUE, main = "PCA.w.phylo")
make_ggplot(P)

}
\author{
Michael Collyer
}
\keyword{utilities}
