% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorph.support.code.r
\name{mshape}
\alias{mshape}
\title{Estimate mean shape for a set of aligned specimens}
\usage{
mshape(A, na.action = 1)
}
\arguments{
\item{A}{Either a list (length n, p x k), A 3D array (p x k x n), or a matrix (n x pk) containing GPA-aligned coordinates for a set of specimens}

\item{na.action}{An index for how to treat missing values: 1 = stop analysis; 2 = return NA for coordinates
with missing values for any specimen; 3 = attempt to calculate means for coordinates for all non-missing values.}
}
\description{
Estimate the mean shape for a set of aligned specimens
}
\details{
The function estimates the average landmark coordinates for a set of aligned specimens. 
Three different methods are available for missing data (see Arguments and Examples).
 
 One can then use the generic function \code{\link{plot}} to produce a numbered plot of landmark 
 positions and potentially add links, in order to review landmark positions
}
\examples{
\dontrun{
data(plethodon)
Y.gpa <- gpagen(plethodon$land)    #GPA-alignment
A <- Y.gpa$coords
A[[1]] <- NA # make a missing value, just for example

mshape(Y.gpa$coords)   # mean (consensus) configuration
# mshape(A, na.action = 1) # will return an error
mshape(A, na.action = 2) # returns NA in spot of missing value
mshape(A, na.action = 3) # finds mean values from all possible values
}
}
\author{
Antigoni Kaliontzopoulou & Michael Collyer
}
\keyword{utilities}
