% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistar_add_dimension.R
\name{add_dimension}
\alias{add_dimension}
\alias{add_dimension.multistar}
\title{Add a dimension table to a \code{multistar}}
\usage{
add_dimension(
  ms,
  dimension_name = NULL,
  dimension_table = NULL,
  dimension_key = NULL,
  fact_name = NULL,
  fact_key = NULL,
  key_as_data = FALSE
)

\method{add_dimension}{multistar}(
  ms,
  dimension_name = NULL,
  dimension_table = NULL,
  dimension_key = NULL,
  fact_name = NULL,
  fact_key = NULL,
  key_as_data = FALSE
)
}
\arguments{
\item{ms}{A \code{multistar} object.}

\item{dimension_name}{A string, name of dimension table.}

\item{dimension_table}{A \code{tibble}, dimension table.}

\item{dimension_key}{A string, name of the dimension primary key.}

\item{fact_name}{A string, name of fact table.}

\item{fact_key}{A string, name of the dimension foreign key.}

\item{key_as_data}{A boolean, define the primary key as an attribute of the
dimension accessible in queries?}
}
\value{
A \code{multistar}.
}
\description{
To add a dimension table to a \code{multistar} object, we must indicate the name
that we give to the dimension, the \code{tibble} that contains the data and the
name of the attribute corresponding to the table primary key.
}
\details{
We cannot add a dimension without defining a correspondence with one of the
\code{multistar}'s fact tables. We have to define the name of the fact table and
the name of its foreign key. The referential integrity of the instances of
the facts is checked.

The attribute that is used as the primary key will no longer be accessible
for queries (its function is considered to be exclusively related to facts).
If you want to use it for queries, it must be explicitly indicated by the
boolean parameter \code{key_as_data}.
}
\examples{
library(tidyr)

ms <- multistar() \%>\%
  add_facts(
    fact_name = "mrs_age",
    fact_table = mrs_fact_age,
    measures = "n_deaths",
    nrow_agg = "count"
  ) \%>\%
  add_facts(
    fact_name = "mrs_cause",
    fact_table = mrs_fact_cause,
    measures = c("pneumonia_and_influenza_deaths", "other_deaths"),
    nrow_agg = "nrow_agg"
  ) \%>\%
  add_dimension(
    dimension_name = "where",
    dimension_table = mrs_where,
    dimension_key = "where_pk",
    fact_name = "mrs_age",
    fact_key = "where_fk"
  ) \%>\%
  add_dimension(
    dimension_name = "when",
    dimension_table = mrs_when,
    dimension_key = "when_pk",
    fact_name = "mrs_age",
    fact_key = "when_fk",
    key_as_data = TRUE
  ) \%>\%
  add_dimension(
    dimension_name = "who",
    dimension_table = mrs_who,
    dimension_key = "who_pk",
    fact_name = "mrs_age",
    fact_key = "who_fk"
  )

}
\seealso{


Other multistar functions: 
\code{\link{add_facts}()},
\code{\link{multistar}()},
\code{\link{relate_dimension}()}
}
\concept{multistar functions}
