% 2024-02-09 A. Papritz
% R CMD Rdconv -t html -o bla.html compress.Rd ; open bla.html; R CMD Rd2pdf --force compress.Rd;

%  hunspell -d en_GB -t -i mac  *.Rd

\encoding{utf8}
\name{compress}
\alias{compress}
\alias{expand}

\title{Compact Storage of Symmetric and Triangular Matrices}
\description{
  The utility function \code{compress} stores symmetric or triangular
  matrices compactly by retaining only the diagonal and either the
  lower or upper off-diagonal elements.  The function \code{expand}
  restores such compressed matrices again to a square form.  }

\usage{
  compress(m)

  expand(object)
}

\arguments{
  \item{m}{either a single symmetric, lower or upper triangular
  matrix or a list of such matrices.  The type of \code{m} (or of its
  component matrices) must be defined by the attribute \code{struc} with
  possible values \code{"sym"} (symmetric), \code{"lt"} (lower triangular)
  or \code{"ut"} (upper triangular).}

  \item{object}{a single compressed matrix or a list of such matrices
  generated by \code{compress}, see \emph{Value}.  The type of
  \code{object} (or of its components) must be defined by the
  attribute \code{struc} with possible values \code{"sym"} (symmetric),
  \code{"lt"} (lower triangular) or \code{"ut"} (upper triangular).}


}
\value{
  If \code{m} is a single square matrix then \code{compress} generates a
  compressed matrix, which is a list with two components:

  \item{\code{diag}}{a vector with the diagonal elements of \code{m}.}

  \item{\code{tri}}{a vector with off-diagonal elements.}

  If \code{m} is a list of square matrices then the result is also a list
  of compressed matrices.

  \code{expand} creates a square matrix if \code{object} is a list with
  components \code{diag} and \code{tri} and a list of square matrices if
  \code{object} is a list of such lists.  If \code{m} or \code{objects} are
  lists that contain other components than square or compressed matrices
  then these additional components are returned unchanged.

}

\author{
  Andreas Papritz \email{papritz@retired.ethz.ch}.
}

\seealso{
  \code{\link{georob}} for (robust) fitting of spatial linear models.
}

\examples{
data(meuse)

r.logzn.rob <- georob(log(zinc) ~ sqrt(dist) + ffreq, data = meuse,
    locations = ~ x + y, variogram.model = "RMexp",
    param = c(variance = 0.15, nugget = 0.05, scale = 200),
    tuning.psi = 1)

cov2cor(expand(r.logzn.rob[["cov"]][["cov.betahat"]]))
}

\keyword{models}
\keyword{spatial}
\keyword{robust}
