\name{est.variograms}
\alias{est.variograms}

\title{
Variogram Estimator
}
\description{
Calculate empirical \code{variogram} estimates. An object of class
variogram contains empirical variogram estimates which are generated
from a point object and a pair object. A variogram object is stored
as a data frame containing seven columns: \code{lags}, \code{bins},
\code{classic}, \code{robust},\code{med}, \code{trim} and
\code{n}. The length of each vector is equal to the number of lags
in the pair object used to create the variogram object, say l. The
\code{lags} vector contains the lag numbers for each lag, beginning
with one (1) and going to the number of lags (l). The \code{bins} vector
contains the spatial midpoint of each lag. The \code{classic}, \code{robust},
\code{med} and \code{trimmed.mean} vectors contain: the classical,
robust, median, and trimmed mean, respectively, which are given, respectively,
by (see Cressie, 1993, p. 75)

classical
\deqn{
\gamma_{c}(h)=\frac{1}{n}\sum_{(i,j)\in 
    N(h)}(z(x_{i})-z(x_{j}))^{2}
}

robust,
\deqn{
\gamma_{m}(h)=\frac{(\frac{1}{n}\sum_{(i,j)\in N(h)}
    (\sqrt{|z(x_{i})-z(x_{j})|}))^{4}}{0.457+\frac{0.494}{n}}
}

median
\deqn{
\gamma_{me}(h)=\frac{\mbox(median_{(i,j)\in N(h)}
     (\sqrt{|z(x_{i})-z(x_{j})|}))^{4}}{0.457+\frac{0.494}{|N(h)|}}
}

and trimmed mean
\deqn{
\gamma_{tm}(h)=\frac{(trimmed.mean_{(i,j)\in N(h)}(\sqrt{|z(x_{i})-z(x_{j})|}))^{4}}{0.457+\frac{0.494}{|N(h)|}}
}

The \eqn{n} vector contains the number \eqn{|N(h)|} of pairs of points
in each lag \eqn{N(h)}.
}
\usage{
est.variograms(point.obj, pair.obj, a1, a2, trim)
}

\arguments{
\item{point.obj}{a point object generated by \code{point()}}
\item{pair.obj}{a pair object generated by \code{pair()}}
\item{a1}{a variable to calculate semivariogram for}
\item{a2}{an optional variable name, if entered cross variograms will be created between \code{a1} and \code{a2}}
\item{trim}{percent of trimmed mean}
}
\value{
A variogram object: 
\item{lags}{vector of lag identifiers}
\item{bins}{vector of midpoints of each lag}
\item{classic}{vector of classic variogram estimates for each lag}
\item{robust}{vector of robust variogram estimates for each lag}
\item{med}{vector of median variogram estimates for each lag}
\item{trimmed.mean}{vector of trimmed mean variogram estimates for each lag}
\item{n}{vector of the number of pairs in each lag}
}
\references{
Bardossy, A., 2001. \emph{Introduction to Geostatistics}. University of Stuttgart.

Cressie, N.A.C., 1993. \emph{Statistics for Spatial Data}. Wiley.

Majure, J., Gebhardt, A., 2009. sgeostat: An Object-oriented Framework for Geostatistical Modeling in S+. R package version 1.0-23.

Roustant O., Dupuy, D., Helbert, C., 2007. \emph{Robust Estimation of the Variogram in Computer Experiments}. Ecole des Mines, Departement 3MI, 158 Cours Fauriel, 42023 Saint-Etienne, France
}
\note{
Based on the \code{\link[sgeostat]{est.variogram}} function of the \code{sgeostat} package
}
\seealso{
\code{\link[sgeostat]{point}}, \code{\link[sgeostat]{pair}}
}
\examples{
library(sgeostat, pos=which(search()=="package:gstat")+1)
data(maas)
maas.point <- point(maas) 
maas.pair <- pair(maas.point, num.lags=24, maxdist=2000) 
maas.v <- est.variograms(maas.point,maas.pair,'zinc',trim=0.1) 
maas.v
}

\keyword{ spatial }