% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.R
\name{mc}
\alias{mc}
\title{The Moran coefficient}
\source{
Chun, Yongwan, and Daniel A. Griffith. Spatial Statistics and Geostatistics: Theory and Applications for Geographic Information Science and Technology. Sage, 2013.

Cliff, Andrew David, and J. Keith Ord. Spatial processes: models & applications. Taylor & Francis, 1981.
}
\usage{
mc(x, w, digits = 3, warn = TRUE, na.rm = FALSE)
}
\arguments{
\item{x}{Numeric vector of input values, length n.}

\item{w}{An n x n spatial connectivity matrix. See \code{\link[geostan]{shape2mat}}.}

\item{digits}{Number of digits to round results to.}

\item{warn}{If \code{FALSE}, no warning will be printed to inform you when observations with zero neighbors or \code{NA} values have been dropped.}

\item{na.rm}{If \code{na.rm = TRUE}, observations with \code{NA} values will be dropped from both \code{x} and \code{w}.}
}
\value{
The Moran coefficient, a numeric value.
}
\description{
The Moran coefficient, a measure of spatial autocorrelation (also known as Global Moran's I)
}
\details{
The formula for the Moran coefficient (MC) is
\deqn{MC = \frac{n}{K}\frac{\sum_i \sum_j w_{ij} (y_i - \overline{y})(y_j - \overline{y})}{\sum_i (y_i - \overline{y})^2}}
where \eqn{n} is the number of observations and \eqn{K} is the sum of all values in the spatial connectivity matrix \eqn{W}, i.e., the sum of all row-sums: \eqn{K = \sum_i \sum_j w_{ij}}.

If any observations with no neighbors are found (i.e. \code{any(Matrix::rowSums(w) == 0)}) they will be dropped automatically and a message will print stating how many were dropped. The alternative is for those observations to have a spatial lage of zero---but zero is not a neutral value, see the Moran scatter plot.
}
\examples{
library(sf)
data(georgia)
w <- shape2mat(georgia, style = "W")
x <- georgia$ICE
mc(x, w)
}
\seealso{
\link[geostan]{moran_plot}, \link[geostan]{lisa}, \link[geostan]{aple}, \link[geostan]{gr}, \link[geostan]{lg}
}
