% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{shape2mat}
\alias{shape2mat}
\title{Create spatial and space-time connectivity matrices}
\source{
Bivand, Roger S. and Pebesma, Edzer and Gomez-Rubio, Virgilio (2013). Applied spatial data analysis with R, Second edition. Springer, NY. https://asdar-book.org/

Griffith, Daniel A. (2012). Space, time, and space-time eigenvector filter specifications that account for autocorrelation. Estadística Espanola, 54(177), 7-34.

Haining, Robert P. and Li, Guangquan (2020). Regression Modelling Wih Spatial and Spatial-Temporal Data: A Bayesian Approach. CRC Press.
}
\usage{
shape2mat(
  shape,
  style = c("B", "W"),
  queen = TRUE,
  snap = sqrt(.Machine$double.eps),
  t = 1,
  st.style = c("contemp", "lag")
)
}
\arguments{
\item{shape}{An object of class \code{sf}, \code{SpatialPolygons} or \code{SpatialPolygonsDataFrame}.}

\item{style}{What kind of coding scheme should be used to create the spatial connectivity matrix? Defaults to "B" for binary; use "W" for row-standardized weights.}

\item{queen}{Passed to \code{\link[spdep]{poly2nb}} to set the contiguity condition. Defaults to \code{TRUE} so that a single shared boundary point (rather than a shared border/line) between polygons is sufficient for them to be considered neighbors.}

\item{snap}{Passed to \code{\link[spdep]{poly2nb}}; "boundary points less than ‘snap’ distance apart are considered to indicate contiguity."}

\item{t}{Number of time periods. Only the binary coding scheme is available for space-time connectivity matrices.}

\item{st.style}{For space-time data, what type of space-time connectivity structure should be used? Options are "lag" for the lagged specification and "contemp" (the default) for contemporaneous specification (see Details).}
}
\value{
A spatial connectivity matrix
}
\description{
Creates sparse matrix representations of spatial connectivity structures
}
\details{
Haining and Li (Ch. 4) provide a helpful discussion of spatial connectivity matrices (Ch. 4).

The space-time connectivity matrix can be used for eigenvector space-time filtering (\code{\link[geostan]{stan_esf}}. The \verb{lagged' space-time structure connects each observation to its own past (one period lagged) value and the past value of its neighbors. The }contemporaneous' specification links each observation to its neighbors and to its own in situ past (one period lagged) value (Griffith 2012, p. 23).
}
\examples{
data(georgia)

## binary adjacency matrix
C <- shape2mat(georgia, "B")
## row sums gives the numbers of neighbors per observation
Matrix::rowSums(C)
head(Matrix::summary(C))

## row-standardized matrix 
W <- shape2mat(georgia, "W")
Matrix::rowSums(W)
head(Matrix::summary(W))

## space-time matricies 
## for eigenvector space-time filtering
## if you have multiple years with same neighbors,
## provide the geography (for a single year!) and number of years \code{t}
Cst <- shape2mat(georgia, t = 5)
dim(Cst)
EVst <- make_EV(Cst)
dim(EVst)
}
\seealso{
\code{\link[geostan]{edges}} \code{\link[geostan]{prep_car_data}} \code{\link[geostan]{prep_icar_data}}
}
