% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-analysis.R
\name{eigen_grid}
\alias{eigen_grid}
\title{Eigenvalues of a spatial weights matrix: raster analysis}
\source{
Griffith, Daniel A. (2000). Eigenfunction properties and approximations of selected incidence matrices employed in spatial analyses. \emph{Linear Algebra and its Applications} 321 (1-3): 95-112. \doi{10.1016/S0024-3795(00)00031-8}.
}
\usage{
eigen_grid(row = 5, col = 5)
}
\arguments{
\item{row}{Number of rows in the raster dataset}

\item{col}{Number of columns in the raster dataset}
}
\description{
Approximate eigenvalues for the row-standardized spatial connectivity matrix W of a regular tessellation, e.g., remotely sensed imagery.
}
\details{
Uses Equation 5 from Griffith (2000) to calculate the eigenvalues for a row-standardized spatial weights matrix; this is valid for a regular tessellation (rectangular grid or raster). The rook criteria is used to define adjacency.

The purpose is to calculate eigenvalues of the spatial weights matrix for the CAR and SAR models, enabling spatial regression with large raster data sets. This function is used internally by \code{\link[geostan]{prep_sar_data2}} and \code{\link[geostan]{prep_car_data2}}. For more details, see: \code{vignette("raster-regression", package = "geostan")}.
}
\examples{

e <- eigen_grid(row = 50, col = 95)
print(head(e, 25))

}
\seealso{
\code{\link[geostan]{prep_sar_data2}}, \code{\link[geostan]{prep_car_data2}}
}
