% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gboot_variogram.R
\name{gboot_variogram}
\alias{gboot_variogram}
\title{Variogram bootstrap}
\usage{
gboot_variogram(data,var,model,B)
}
\arguments{
\item{data}{object of the class geodata.}

\item{var}{object of the class variogram.}

\item{model}{object of the class variomodel.}

\item{B}{number of the bootstrap that will be performed (default B=1000).}
}
\value{
\bold{variogram_boot} gives the variogram of each bootstrap.

\bold{variogram_or} gives the original variogram.

\bold{pars_boot} gives the estimatives of the nugget, sill, contribution, range and practical range for each bootstrap.

\bold{pars_or} gives the original estimatives of the nugget, sill, contribution, range and practical range.

Invalid arguments will return an error message.
}
\description{
Perform a boostrap based on error from the fitted model of the variogram.
}
\details{
The algorithm for the bootstrap variogram is the same presented for
Davison and Hinkley (1997) for the non linear regression. We can write the
variogram as \eqn{\hat \gamma(h) = \gamma_{mod}(h)+\epsilon}, where \eqn{\gamma_{mod}(h)}
is the fitted model. The steps of the algorithm are:

\enumerate{
\item Set \eqn{h^*=h};
\item Sample with replacement \eqn{\epsilon^*} from \eqn{\epsilon - \bar \epsilon};
\item The new variogram will be \eqn{\gamma^*(h^*) = \gamma_{mod}(h)+\epsilon^*};
\item Calculate and save the statistics of interest;
\item Return to step 2 and repeat the process at least 1000 times.
}
}
\examples{
# Example 1

## transforming the data.frame in an object of class geodata
data<- as.geodata(soilmoisture)

points(data) ## data visualization

var<- variog(data, max.dist = 140) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(2,80),nugget = 2,cov.model = "sph")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_variogram(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot

\dontrun{
# Example 2

## transforming the data.frame in an object of class geodata
data<- as.geodata(NVDI)

points(data) ## data visualization

var<- variog(data, max.dist = 18) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(0.003,6),nugget = 0.003,cov.model = "gaus")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_variogram(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot
}
}
\references{
DAVISON, A.C.; HINKLEY, D. V. Bootstrap Methods and their Application. [s.l.] Cambridge University Press, 1997. p. 582
}
\author{
Diogo Francisco Rossoni \email{dfrossoni@uem.br}

Vinicius Basseto Felix \email{felix_prot@hotmail.com}
}
\keyword{Bootstrap}
\keyword{Spatial}
\keyword{Variogram}
