% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.keyword.v0.R
\name{replace.keyword}
\alias{replace.keyword}
\title{It replaces some keyword values of \code{geotop.inpts} file with the ones of anoter \code{*.inpts}  value}
\usage{
replace.keyword(x, y = "geotop.inpts", file.output = NULL,
  write.file.output = TRUE, wpath = NULL, ...)
}
\arguments{
\item{x}{filename of the \code{*.inpts} with the "new" keyword value}

\item{y}{filename of the \code{*.inpts} with the "old" keyword value. Default is \code{"geotop.inpts"}.}

\item{file.output}{filename where to write the comprehensive new \code{geotop.inpts} file. If it is \code{NULL} (default), the fileneme is assigned by \code{y}.}

\item{write.file.output}{logical value. If it is \code{TRUE}, the output of the function is written in he file \code{file.output}.}

\item{wpath}{working path to the GEOtop simulation folder containing the \code{x} and \code{y} files.}

\item{...}{further arguments}
}
\description{
It replaces some keyword values of \code{geotop.inpts} file with the ones of anoter \code{*.inpts}  value
}
\details{
This function repleces some keword values of \code{y} with the ones indicated in \code{y}. It is useful to replace the meteo station metedata, for instance, when the meteorological station of a study cases are modified. 
The function returns the new \code{geotop.inpts} file as a vector of character strings. If \code{write.file.output==TRUE}, the output is written in an extarnal file, e.g. \code{"geotop.inpts"} newly (this option is suggested).
}
\examples{

library(geotopbricks)
wpath <- system.file('template/meteo_ex',package="geotopbricks")
x <- "meteo.inpts"
zl <- replace.keyword(x,wpath=wpath,write.file.output=FALSE)



}
\author{
Emanuele Cordano
}
