% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elevation_transparency.R
\name{elevation_transparency}
\alias{elevation_transparency}
\title{Turns overlay images transparent based on altitude. Can be used to create an
image overlay that will only apply to valleys, or only to hills.}
\usage{
elevation_transparency(overlay_image, raster_dem, alpha_max = 0.4,
  alpha_min = 0, pct_alt_low = 0.05, pct_alt_high = 0.25)
}
\arguments{
\item{overlay_image}{the image on which to alter transparency}

\item{raster_dem}{elevation model raster file that will be used to adjust transparency}

\item{alpha_max}{Transparency required at higher altitudes}

\item{alpha_min}{Transparency required at lower altitudes}

\item{pct_alt_low}{The percent of maximum altitude contained in raster_dem
at which alpha_max will apply}

\item{pct_alt_high}{The percent of maximum altitude contained in raster_dem
at which alpha_min will apply}
}
\value{
An image with transparency defined by altitude
}
\description{
Turns overlay images transparent based on altitude. Can be used to create an
image overlay that will only apply to valleys, or only to hills.
}
\examples{
# elevation_transparency defaults to making hills transparent.  Flip alpha_max
# and alpha_min values to reverse it.
#
# Transparency in the range between pct_alt_low and pct_alt_high will
# smoothly transition between alpha_max and alpha_min.

 overlay_image <- elevation_shade(example_raster(), elevation_palette = c("#000000", "#FF0000"))

 #Making hills transparent

 ggmap_overlay_transparent_hills <- elevation_transparency(overlay_image,
   example_raster(), alpha_max = 0.8, alpha_min = 0, pct_alt_low = 0.05,
   pct_alt_high = 0.25)

 # To make valleys transparent, flip alpha_max and alpha_min
 ggmap_overlay_transparent_valleys <- elevation_transparency(overlay_image,
   example_raster(), alpha_max = 0, alpha_min = 0.8, pct_alt_low = 0.05,
   pct_alt_high = 0.25)
}
