% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/article_bib.R
\name{article_bib}
\alias{article_bib}
\title{Preparer of main references for automatic insertion in scientific articles}
\usage{
article_bib(input_date, input_tam, position_artic, total_list)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database obtained of colection WoS, Scopus and others}

\item{input_tam}{is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.}

\item{position_artic}{is a parameter that shows the positions of the articles in the main list, obtained using package bibliorefer, chosen to be included in the reference list of a scientific paper. If part of the list is used, the set of articles is presented through a sequence or a concatenated set. If the complete list is used, the complete sequence is created}

\item{total_list}{is the parameter that defines whether all articles from the main list, obtained using package bibliorefer, will be used or not. This parameter contains the logical values TRUE or FALSE. If the full list is used, the value is TRUE. Otherwise, if a part of the list is used, the value is FALSE}
}
\value{
This function returns a file with the .bib extension, containing the list of references in bibtex format, prepared to be automatically included in the reference list of a scientific paper.
}
\description{
The article_bib function prepares the metadata of the main scientific references to be automatically included in a scientific article. Initially, the user obtains the list of main references using the principal_lister function from the bibliorefer package.  Then, read the articles, choose the ones you prefer, and display the positions of these articles in the input parameter, position_artic, of the article_bib function. The article_bib function internally calls the gerard_lister and bibtex_lister functions. The gerard_lister function separates and organizes the metadata, of each of the articles in the list chosen by the user, and stores them in a dataframe. Then, the bibtex_lister function is applied to the set of metadata organized in the dataframe and converts it to the BibTex style. The output of the article_bib function is the file with the .bib extension, containing the list of references in BibTex format, prepared to be automatically included in the reference list of a scientific paper.
}
\examples{

# Example 1 - Concatenated position article

# File of database
file_db <- system.file("extdata","example_database.csv", package = "gerefer")
separator <- ","

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 50
total_list <- FALSE
position_artic <- c(1, 2, 3, 5, 6, 8, 10, 12, 15, 17, 19, 23, 24,
     26, 28, 29, 30, 32, 33, 35, 36, 37, 38, 39, 40, 42, 44, 46, 47, 48)

#Calls the function article_bib
lister_bibtex <- article_bib(input_date, input_tam, position_artic, total_list)
lister_bibtex

# Example 2 - Position article in sequence

# File of database
file_db <- system.file("extdata","example_database.csv", package = "gerefer")
separator <- ","

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 50
total_list <- FALSE
position_artic <- seq(6, 35, 1)

# Call the function article_bib
lister_bibtex <- article_bib(input_date, input_tam, position_artic, total_list)
lister_bibtex

# Example 3 - Total list article

# File of database
file_db <- system.file("extdata","example_database.csv", package = "gerefer")
separator <- ","

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 50
total_list <- TRUE
position_artic <- seq(1, input_tam, 1)

# Call the function article_bib
lister_bibtex <- article_bib(input_date, input_tam, position_artic, total_list)
lister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
