% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/germination.indices.R
\name{germination.indices}
\alias{germination.indices}
\title{Germination Indices}
\usage{
germination.indices(
  data,
  total.seeds.col,
  counts.intervals.cols,
  intervals,
  partial = TRUE,
  PeakGermPercent = TRUE,
  FirstGermTime = TRUE,
  LastGermTime = TRUE,
  PeakGermTime = TRUE,
  TimeSpreadGerm = TRUE,
  t50 = TRUE,
  MeanGermTime = TRUE,
  VarGermTime = TRUE,
  SEGermTime = TRUE,
  CVGermTime = TRUE,
  MeanGermRate = TRUE,
  CVG = TRUE,
  VarGermRate = TRUE,
  SEGermRate = TRUE,
  GermRateRecip = TRUE,
  GermSpeed = TRUE,
  GermSpeedAccumulated = TRUE,
  GermSpeedCorrected = TRUE,
  WeightGermPercent = TRUE,
  MeanGermPercent = TRUE,
  MeanGermNumber = TRUE,
  TimsonsIndex = TRUE,
  GermRateGeorge = TRUE,
  max.int,
  GermIndex = TRUE,
  EmergenceRateIndex = TRUE,
  PeakValue = TRUE,
  GermValue = TRUE,
  gv.k = 10,
  CUGerm = TRUE,
  GermSynchrony = TRUE,
  GermUncertainty = TRUE
)
}
\arguments{
\item{data}{A data frame with the germination count data. It should possess
columns with \itemize{ \item Partial or cumulative germination counts per
time interval (to be indicated by the argument \code{counts.intervals.cols}
and \item Total number of seeds tested (to be indicated by the argument
\code{total.seeds.col}). }}

\item{total.seeds.col}{The name of the column in \code{data} with the total
number of seeds tested.}

\item{counts.intervals.cols}{The names of columns in \code{data} with the
germination counts (partial or cumulative, as indicated by the argument
\code{partial}) per time interval (indicated by the argument
\code{intervals}).}

\item{intervals}{The time intervals at which germination counts (in the
columns specified in argument \code{counts.intervals.cols})  were recorded.}

\item{partial}{logical. If \code{TRUE}, germination counts in
\code{counts.intervals.cols} is considered as partial and if \code{FALSE},
it is considered as cumulative. Default is \code{TRUE}.}

\item{PeakGermPercent}{logical. If \code{TRUE}, then the Peak germination
percentage
\insertCite{vallance_studies_1950,roh_maturity_2004}{germinationmetrics} is
computed. Default is \code{TRUE}.}

\item{FirstGermTime}{logical. If \code{TRUE}, the Time of first germination
or Germination time lag (\mjseqn{t_{0}})
\insertCite{edwards_temperature_1932,czabator_germination_1962,goloff_germination_1975,labouriau_germinacao_1983,ranal_effects_1999,quintanilla_effect_2000}{germinationmetrics}
 is computed. Default is \code{TRUE}.}

\item{LastGermTime}{logical. If \code{TRUE}, the Time of last germination
(\mjseqn{t_{g}})
\insertCite{edwards_temperature_1932,labouriau_germinacao_1983,ranal_how_2006}{germinationmetrics}.
 is computed. Default is \code{TRUE}.}

\item{PeakGermTime}{logical. If \code{TRUE}, the Peak time of germination or
Modal time of germination \insertCite{ranal_how_2006}{germinationmetrics}
is computed. Default is \code{TRUE}.}

\item{TimeSpreadGerm}{logical. If \code{TRUE}, the Time spread of germination
\insertCite{al-mudaris_notes_1998,kader_comparison_2005}{germinationmetrics}
 or Germination distribution
\insertCite{schrader_seed_2000}{germinationmetrics}. is computed. Default
is \code{TRUE}.}

\item{t50}{logical. If \code{TRUE}, the Median germination time
(\mjseqn{t_{50}})
\insertCite{coolbear_effect_1984,farooq_thermal_2005}{germinationmetrics}
is computed. Default is \code{TRUE}.}

\item{MeanGermTime}{logical. If \code{TRUE}, the Mean germination time
(\mjseqn{\overline{T}}) or Mean length of incubation time
\insertCite{edmond_effects_1958,czabator_germination_1962,ellis_improved_1980,labouriau_germinacao_1983,ranal_how_2006}{germinationmetrics}.
 or Sprouting index (\mjseqn{SI})
\insertCite{smith_germinating_1964}{germinationmetrics} or Germination
Resistance (\mjseqn{GR})
\insertCite{gordon_observations_1969,gordon_germination_1971;textual}{germinationmetrics}
 is computed. Default is \code{TRUE}.}

\item{VarGermTime}{logical. If \code{TRUE}, the Variance of germination time
(\mjseqn{s_{T}^{2}})
\insertCite{labouriau_germinacao_1983,ranal_how_2006}{germinationmetrics}
is computed. Default is \code{TRUE}.}

\item{SEGermTime}{logical. If \code{TRUE}, the Standard error of germination
time (\mjseqn{s_{\overline{T}}})
\insertCite{labouriau_germinacao_1983,ranal_how_2006}{germinationmetrics}.
is computed. Default is \code{TRUE}.}

\item{CVGermTime}{logical. If \code{TRUE}, the Coefficient of variation of
the germination time (\mjseqn{CV_{T}})
\insertCite{ranal_how_2006}{germinationmetrics} is computed. Default is
\code{TRUE}.}

\item{MeanGermRate}{logical. If \code{TRUE}, the Mean germination rate
(\mjseqn{\overline{V}})
\insertCite{labouriau_germination_1976,labouriau_uma_1983,ranal_how_2006}{germinationmetrics}.
 is computed. Default is \code{TRUE}.}

\item{CVG}{logical. If \code{TRUE}, the Coefficient of velocity/rate of
germination or Kotowski's coefficient of velocity (\mjseqn{CVG})
\insertCite{kotowski_temperature_1926,nichols_two_1968,labouriau_uma_1983,scott_review_1984,bewley_seeds_1994}{germinationmetrics}.
 is computed. Default is \code{TRUE}.}

\item{VarGermRate}{logical. If \code{TRUE}, the Variance of germination rate
(\mjseqn{s_{V}^{2}})
\insertCite{labouriau_uma_1983,ranal_how_2006}{germinationmetrics} is
computed. Default is \code{TRUE}.}

\item{SEGermRate}{logical. If \code{TRUE}, the Standard error of germination
rate (\mjseqn{s_{\overline{V}}})
\insertCite{labouriau_uma_1983,ranal_how_2006}{germinationmetrics} is
computed. Default is \code{TRUE}.}

\item{GermRateRecip}{logical. If \code{TRUE}, the Germination rate as
reciprocal of median time (\mjseqn{v_{50}})
\insertCite{went_experimental_1957,labouriau_uma_1983,ranal_how_2006}{germinationmetrics}
 is computed.}

\item{GermSpeed}{logical. If \code{TRUE}, the Speed of germination or
Germination rate index or Index of velocity of germination or Germination
index or Emergence rate index
\insertCite{throneberry_relation_1955,maguire_speed_1962,allan_seedling_1962,kendrick_photocontrol_1969,bouton_germination_1976,aosa_seed_1983,khandakar_jute_1983,bradbeer_seed_1988,wardle_allelopathic_1991}{germinationmetrics}
 considering both counts and percentages is computed.}

\item{GermSpeedAccumulated}{logical. If \code{TRUE}, the Speed of accumulated
germination
\insertCite{bradbeer_seed_1988,wardle_allelopathic_1991,haugland_experiments_1996,de_santana_alise_2004}{germinationmetrics}
 considering both counts and percentages is computed.}

\item{GermSpeedCorrected}{logical. If \code{TRUE}, the Corrected speed of
germination or Corrected germination rate index and the Corrected speed of
accumulated germination
\insertCite{evetts_germination_1972}{germinationmetrics} is computed.}

\item{WeightGermPercent}{logical. If \code{TRUE}, the Weighted germination
percentage \mjseqn{WGP} or Weighted germination index \mjseqn{WGI}
\insertCite{reddy_effect_1978,reddy_effect_1985}{germinationmetrics} is
computed.}

\item{MeanGermPercent}{logical. If \code{TRUE}, the Mean/average germination
percentage per unit time (\mjseqn{\overline{GP}})
\insertCite{czabator_germination_1962}{germinationmetrics} is computed.}

\item{MeanGermNumber}{logical. If \code{TRUE}, the Number of seeds germinated
per unit time (\mjseqn{\overline{N}})
\insertCite{khamassi_optimal_2013}{germinationmetrics} is computed.}

\item{TimsonsIndex}{logical. If \code{TRUE}, the Timson's index or Timson's
germination velocity index
\insertCite{grose_laboratory_1958,timson_new_1965,brown_representing_1988,baskin_seeds_1998}{germinationmetrics}
 and it's modifications by Labouriau
\insertCite{ranal_how_2006}{germinationmetrics} and
\insertCite{khan_effect_1984}{germinationmetrics} is computed.}

\item{GermRateGeorge}{logical. If \code{TRUE}, the George's index
\insertCite{george_influence_1961;textual}{germinationmetrics} is computed.}

\item{max.int}{The maximum interval value up to which Timson's index/George's
germination rate is to be computed.}

\item{GermIndex}{logical. If \code{TRUE}, the Germination index according to
\insertCite{melvilleSeedGerminationEarly1980;textual}{germinationmetrics}
and its modification by
\insertCite{de_santana_alise_2004;textual}{germinationmetrics}
\insertCite{ranal_how_2006}{germinationmetrics} are computed.}

\item{EmergenceRateIndex}{logical. If \code{TRUE}, the Emergence rate index
or Germination rate index are computed according to \itemize{ \item
\insertCite{shmueliEmergenceEarlyGrowth1971;textual}{germinationmetrics}
and it's modification by
\insertCite{de_santana_alise_2004;textual}{germinationmetrics}
\insertCite{ranal_how_2006}{germinationmetrics}; \item
\insertCite{bilbroSoilCrustsCotton1982;textual}{germinationmetrics}; and
\item
\insertCite{fakoredeRelationSeedlingVigor1980;textual}{germinationmetrics},
\insertCite{fakoredeVariabilitySeedlingVigour1981;textual}{germinationmetrics},
 and
\insertCite{fakoredeHeteroticEffectsAssociation1983;textual}{germinationmetrics}.}}

\item{PeakValue}{logical. If \code{TRUE}, the Peak value (\mjseqn{PV}) or
Emergence Energy (\mjseqn{EE})
\insertCite{czabator_germination_1962,bonner_ideal_1967}{germinationmetrics}
 is computed.}

\item{GermValue}{logical. If \code{TRUE}, the Germination value
\insertCite{czabator_germination_1962,djavanshir_germination_1976}{germinationmetrics}
 and its modification considering duration from start of test instead of
from onset of germination
\insertCite{brown_representing_1988}{germinationmetrics} is computed.}

\item{gv.k}{The k Constant for computation of germination value. Default is
10.}

\item{CUGerm}{logical. If \code{TRUE}, the Coefficient of uniformity of
germination (CUG)
\insertCite{heydecker_seed_1972,bewley_seeds_1994}{germinationmetrics} is
computed.}

\item{GermSynchrony}{logical. If \code{TRUE}, the Synchrony of germination
(\mjseqn{Z} index)
\insertCite{primack_longevity_1985,ranal_how_2006}{germinationmetrics} is
computed.}

\item{GermUncertainty}{logical. If \code{TRUE}, the Synchronization index
(\mjseqn{\overline{E}}) or Uncertainty of the germination process
(\mjseqn{U}) or Informational entropy (\mjseqn{H})
\insertCite{shannon_mathematical_1948,labouriau_germination_1976,labouriau_uma_1983}{germinationmetrics}
 is computed.}
}
\value{
A data frame with the original data along with the various
  single-value germination indices specified in the function arguments.
}
\description{
Compute germination indices from a data frame of germination counts recorded
at specific time intervals for multiple samples in batch. \loadmathjax
}
\examples{

\donttest{
data(gcdata)

counts.per.intervals <- c("Day01", "Day02", "Day03", "Day04", "Day05",
                          "Day06", "Day07", "Day08", "Day09", "Day10",
                          "Day11", "Day12", "Day13", "Day14")
germination.indices(gcdata, total.seeds.col = "Total Seeds",
                    counts.intervals.cols = counts.per.intervals,
                    intervals = 1:14, partial = TRUE, max.int = 5)
}

}
\references{
\insertAllCited{}
}
\seealso{
This function is a wrapper around the different functions for
  computation of single-value germination indices in
  \href{https://cran.r-project.org/package=germinationmetrics}{germinationmetrics}
   (\code{\link[germinationmetrics]{PeakGermPercent}},
  \code{\link[germinationmetrics]{FirstGermTime}},
  \code{\link[germinationmetrics:FirstGermTime]{LastGermTime}},
  \code{\link[germinationmetrics:FirstGermTime]{PeakGermTime}},
  \code{\link[germinationmetrics:FirstGermTime]{TimeSpreadGerm}},
  \code{\link[germinationmetrics]{t50}},
  \code{\link[germinationmetrics]{MeanGermTime}},
  \code{\link[germinationmetrics:MeanGermTime]{VarGermTime}},
  \code{\link[germinationmetrics:MeanGermTime]{SEGermTime}},
  \code{\link[germinationmetrics:MeanGermTime]{CVGermTime}},
  \code{\link[germinationmetrics]{MeanGermRate}},
  \code{\link[germinationmetrics:MeanGermRate]{CVG}},
  \code{\link[germinationmetrics:MeanGermRate]{VarGermRate}},
  \code{\link[germinationmetrics:MeanGermRate]{SEGermRate}},
  \code{\link[germinationmetrics:MeanGermRate]{GermRateRecip}},
  \code{\link[germinationmetrics]{GermSpeed}},
  \code{\link[germinationmetrics:GermSpeed]{GermSpeedAccumulated}},
  \code{\link[germinationmetrics:GermSpeed]{GermSpeedCorrected}},
  \code{\link[germinationmetrics]{WeightGermPercent}},
  \code{\link[germinationmetrics]{MeanGermPercent}},
  \code{\link[germinationmetrics:GermSpeed]{MeanGermPercent}},
  \code{\link[germinationmetrics]{TimsonsIndex}},
  \code{\link[germinationmetrics:TimsonsIndex]{GermRateGeorge}},
  \code{\link[germinationmetrics]{GermIndex}},
  \code{\link[germinationmetrics]{EmergenceRateIndex}},
  \code{\link[germinationmetrics]{GermValue}},
  \code{\link[germinationmetrics:GermValue]{PeakValue}},
  \code{\link[germinationmetrics]{CUGerm}},
  \code{\link[germinationmetrics]{GermSynchrony}},
  \code{\link[germinationmetrics:GermSynchrony]{GermUncertainty}})
}
