% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{survfit_fast}
\alias{survfit_fast}
\title{Create lifetable quickly}
\usage{
survfit_fast(time, events)
}
\arguments{
\item{time}{Vector of event/censoring times}

\item{events}{Vector of indicators for whether each time is an event (1) or a censoring (0). Must be same length vector as time argument.}
}
\value{
Returns a list format lifetable with the following entries:
\itemize{
 \item{"n"}{Number of patients}
 \item{"time"}{Vector of times}
 \item{"n.risk"}{Vector of numbers of patients at risk at each time}
 \item{"n.event"}{Vector of numbers of patients with an event at each time}
 \item{"n.censor"}{Vector of numbers of patients censored at each time}
 \item{"surv"}{Vector of estimates of Survival function at each time}
 \item{"se"}{Vector of standard errors of estimates of Survival function at each time}
}
}
\description{
Simple, fast function to generate basic lifetables. No error checking is performed.
}
\examples{
survfit_fast(c(1,2,3,3,4,5),c(1,0,1,1,0,1))
}
\author{
James Bell
}
