% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hostname2ip.r
\name{hostname2ip}
\alias{hostname2ip}
\title{hostname2ip}
\usage{
hostname2ip(hosts)
}
\arguments{
\item{hosts}{A vector of hostnames as strings (or just one).}
}
\value{
A list of vectors of IP's.  Each IP is stored as a string.
}
\description{
Converts a hostname (or vector of hostnames) to
}
\details{
Only IPv4 addresses will be returned. If only IPv6 addresses exist (and if
that is the case, allow me to be the first to greet you, person from the
distant future) then \code{NA} is returned for that hostname.

The function uses \code{getaddrinfo()} on *NIX systems, and
\code{gethostbyname()} on Windows.
}
\examples{
library(getip)

\donttest{
hosts = c("www.google.com", "localhost", "www.yahoo.com")
hostname2ip(hosts)
}

}
