% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiQuantile}
\alias{gfiQuantile}
\title{Fiducial quantiles}
\usage{
gfiQuantile(parameter, fidsamples, probs)
}
\arguments{
\item{parameter}{a right-sided formula defining the parameter of interest}

\item{fidsamples}{fiducial samples, the output of \code{\link{gfilogisreg}}}

\item{probs}{numeric vector of probabilities}
}
\value{
Numeric vector of quantiles, of the same length as \code{probs}.
}
\description{
Quantiles of the fiducial distribution of a parameter of
  interest.
}
\examples{
y <- c(
  0, 0, 0, 1,
  0, 1, 1, 1
)
group <- gl(2, 4)
fidsamples <- gfilogisreg(y ~ 0 + group, N = 500) # (N=500 is not serious)
gfiQuantile(~ group2 - group1, fidsamples, c(25, 50, 75)/100)
}
