% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3methods.R
\name{print.gformula_survival}
\alias{print.gformula_survival}
\title{Print method for objects of class "gformula_survival"}
\usage{
\method{print}{gformula_survival}(x, coefficients = FALSE,
  stderrs = FALSE, rmses = FALSE, hazardratio = FALSE, ...)
}
\arguments{
\item{x}{Object of class "gformula_survival".}

\item{coefficients}{Logical scalar indicating whether to print the model coefficients. The default is \code{FALSE}.}

\item{stderrs}{Logical scalar indicating whether to print the standard error of the model coefficients. The default is \code{FALSE}.}

\item{rmses}{Logical scalar indicating whether to print the model root mean square errors (RMSEs). The default is \code{FALSE}.}

\item{hazardratio}{Logical scalar indicating whether to print the hazard ratio between two interventions (if computed). If bootstrapping was used in \code{\link{gformula_survival}}, 95\% confidence intervals will be given. The default is \code{FALSE}.}

\item{...}{Other arguments.}
}
\value{
No value is returned.
}
\description{
Print method for objects of class "gformula_survival".
}
\examples{
## Estimating the effect of static treatment strategies on risk of a
## failure event
\donttest{
id <- 'id'
time_points <- 7
time_name <- 't0'
covnames <- c('L1', 'L2', 'A')
outcome_name <- 'Y'
covtypes <- c('binary', 'bounded normal', 'binary')
histories <- c(lagged, lagavg)
histvars <- list(c('A', 'L1', 'L2'), c('L1', 'L2'))
covparams <- list(covmodels = c(L1 ~ lag1_A + lag_cumavg1_L1 + lag_cumavg1_L2 +
                                  L3 + t0,
                                L2 ~ lag1_A + L1 + lag_cumavg1_L1 +
                                  lag_cumavg1_L2 + L3 + t0,
                                A ~ lag1_A + L1 + L2 + lag_cumavg1_L1 +
                                  lag_cumavg1_L2 + L3 + t0))
ymodel <- Y ~ A + L1 + L2 + L3 + lag1_A + lag1_L1 + lag1_L2 + t0
intvars <- list('A', 'A')
interventions <- list(list(c(static, rep(0, time_points))),
                      list(c(static, rep(1, time_points))))
int_descript <- c('Never treat', 'Always treat')
nsimul <- 10000

gform_basic <- gformula_survival(obs_data = basicdata_nocomp, id = id,
                                 time_points = time_points,
                                 time_name = time_name, covnames = covnames,
                                 outcome_name = outcome_name,
                                 covtypes = covtypes,
                                 covparams = covparams, ymodel = ymodel,
                                 intvars = intvars,
                                 interventions = interventions,
                                 int_descript = int_descript,
                                 histories = histories, histvars = histvars,
                                 basecovs = c('L3'), nsimul = nsimul,
                                 seed = 1234)
print(gform_basic)
}

}
\seealso{
\code{\link{gformula_survival}}
}
