% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\title{Simulate Counterfactual Outcomes Under Intervention}
\usage{
simulate(
  o,
  fitcov,
  fitY,
  fitD,
  yrestrictions,
  compevent_restrictions,
  restrictions,
  outcome_name,
  compevent_name,
  time_name,
  intvars,
  interventions,
  int_times,
  histvars,
  histvals,
  histories,
  comprisk,
  ranges,
  yrange,
  compevent_range,
  outcome_type,
  subseed,
  obs_data,
  time_points,
  parallel,
  covnames,
  covtypes,
  covparams,
  covpredict_custom,
  basecovs,
  max_visits,
  baselags,
  below_zero_indicator,
  min_time,
  show_progress,
  pb,
  int_visit_type,
  ...
)
}
\arguments{
\item{o}{Integer specifying the index of the current intervention.}

\item{fitcov}{List of model fits for the time-varying covariates.}

\item{fitY}{Model fit for the outcome variable.}

\item{fitD}{Model fit for the competing event variable, if any.}

\item{yrestrictions}{List of vectors. Each vector containins as its first entry
a condition and its second entry an integer. When the
condition is \code{TRUE}, the outcome variable is simulated
according to the fitted model; when the condition is \code{FALSE},
the outcome variable takes on the value in the second entry.}

\item{compevent_restrictions}{List of vectors. Each vector containins as its first entry
a condition and its second entry an integer. When the
condition is \code{TRUE}, the competing event variable is simulated
according to the fitted model; when the condition is \code{FALSE},
the competing event variable takes on the value in the
second entry.}

\item{restrictions}{List of vectors. Each vector contains as its first entry a covariate for which
\emph{a priori} knowledge of its distribution is available; its second entry a condition
under which no knowledge of its distribution is available and that must be \code{TRUE}
for the distribution of that covariate given that condition to be estimated via a parametric
model or other fitting procedure; its third entry a function for estimating the distribution
of that covariate given the condition in the second entry is false such that \emph{a priori} knowledge
of the covariate distribution is available; and its fourth entry a value used by the function in the
third entry. The default is \code{NA}.}

\item{outcome_name}{Character string specifying the name of the outcome variable in \code{obs_data}.}

\item{compevent_name}{Character string specifying the name of the competing event variable in \code{obs_data}.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{intvars}{List, whose elements are vectors of character strings. The kth vector in \code{intvars} specifies the name(s) of the variable(s) to be intervened
on in each round of the simulation under the kth intervention in \code{interventions}.}

\item{interventions}{List, whose elements are lists of vectors. Each list in \code{interventions} specifies a unique intervention on the relevant variable(s) in \code{intvars}. Each vector contains a function
implementing a particular intervention on a single variable, optionally
followed by one or more "intervention values" (i.e.,
integers used to specify the treatment regime).}

\item{int_times}{List, whose elements are lists of vectors. The kth list in \code{int_times} corresponds to the kth intervention in \code{interventions}. Each vector specifies the time points in which the relevant intervention is applied on the corresponding variable in \code{intvars}.
When an intervention is not applied, the simulated natural course value is used. By default, this argument is set so that all interventions are applied in all time points.}

\item{histvars}{List of vectors. The kth vector specifies the names of the variables for which the kth history function
in \code{histories} is to be applied.}

\item{histvals}{List of length two. The first element is a numeric vector specifying the lags used in the model statements (e.g., if \code{lag1_varname} and \code{lag2_varname} were included in the model statements, this vector would be \code{c(1,2)}). The second element is a numeric vector specifying the lag averages used in the model statements.}

\item{histories}{Vector of history functions to apply to the variables specified in \code{histvars}.}

\item{comprisk}{Logical scalar indicating the presence of a competing event.}

\item{ranges}{List of vectors. Each vector contains the minimum and
maximum values of one of the covariates in \code{covnames}.}

\item{yrange}{Vector containing the minimum and maximum values of the
outcome variable in the observed dataset.}

\item{compevent_range}{Vector containing the minimum and maximum values of the
competing event variable in the observed dataset.}

\item{outcome_type}{Character string specifying the "type" of the outcome. The possible "types" are: \code{"survival"}, \code{"continuous_eof"}, and \code{"binary_eof"}.}

\item{subseed}{Integer specifying the seed for this simulation.}

\item{obs_data}{Data table containing the observed data.}

\item{time_points}{Number of time points to simulate.}

\item{parallel}{Logical scalar indicating whether to parallelize simulations of
different interventions to multiple cores.}

\item{covnames}{Character string specifying the name of the competing event variable in \code{obs_data}.}

\item{covtypes}{Vector of character strings specifying the "type" of each time-varying covariate included in \code{covnames}. The possible "types" are: \code{"binary"}, \code{"normal"}, \code{"categorical"}, \code{"bounded normal"}, \code{"zero-inflated normal"}, \code{"truncated normal"}, \code{"absorbing"}, \code{"categorical time"}, and \code{"custom"}.}

\item{covparams}{List of vectors, where each vector contains information for
one parameter used in the modeling of the time-varying covariates (e.g.,
model statement, family, link function, etc.). Each vector
must be the same length as \code{covnames} and in the same order.
If a parameter is not required for a certain covariate, it
should be set to \code{NA} at that index.}

\item{covpredict_custom}{Vector containing custom prediction functions for time-varying
covariates that do not fall within the pre-defined covariate types.
It should be in the same order as \code{covnames}. If a custom
prediction function is not required for a particular
covariate, then that index should be set to \code{NA}.}

\item{basecovs}{Vector of character strings specifying the names of baseline covariates in \code{obs_data}.}

\item{max_visits}{A vector of one or more values denoting the maximum number of times
a binary covariate representing a visit process may be missed before
the individual is censored from the data (in the observed data) or
a visit is forced (in the simulated data). Multiple values exist in the
vector when the modeling of more than covariate is attached to a visit
process.}

\item{baselags}{Logical scalar for specifying the convention used for lagi and lag_cumavgi terms in the model statements when pre-baseline times are not
included in \code{obs_data} and when the current time index, \eqn{t}, is such that \eqn{t < i}. If this argument is set to \code{FALSE}, the value
of all lagi and lag_cumavgi terms in this context are set to 0 (for non-categorical covariates) or the reference
level (for categorical covariates). If this argument is set to \code{TRUE}, the value of lagi and lag_cumavgi terms
are set to their values at time 0. The default is \code{FALSE}.}

\item{below_zero_indicator}{Logical scalar indicating whether the observed data set contains rows for time \eqn{t < 0}.}

\item{min_time}{Numeric scalar specifying lowest value of time \eqn{t} in the observed data set.}

\item{show_progress}{Logical scalar indicating whether to print a progress bar for the number of bootstrap samples completed in the R console. This argument is only applicable when \code{parallel} is set to \code{FALSE} and bootstrap samples are used (i.e., \code{nsamples} is set to a value greater than 0). The default is \code{TRUE}.}

\item{pb}{Progress bar R6 object. See \code{\link[progress]{progress_bar}} for further details.}

\item{int_visit_type}{Vector of logicals. The kth element is a logical specifying whether to carry forward the intervened value (rather than the natural value) of the treatment variables(s) when performing a carry forward restriction type for the kth intervention in \code{interventions}.
When the kth element is set to \code{FALSE}, the natural value of the treatment variable(s) in the kth intervention in \code{interventions} will be carried forward.
By default, this argument is set so that the intervened value of the treatment variable(s) is carried forward for all interventions.}

\item{...}{Other arguments, which are passed to the functions in \code{covpredict_custom}.}
}
\value{
A data table containing simulated data under the specified intervention.
}
\description{
This internal function simulates a new dataset containing covariates, outcome probabilities, competing event
probabilities (if any), outcomes, and competing events (if any) based on an observed
dataset and a user-specified intervention.
}
\keyword{internal}
