% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_helper}
\alias{bootstrap_helper}
\title{Bootstrap Observed Data and Simulate Under All Interventions}
\usage{
bootstrap_helper(
  r,
  time_points,
  obs_data,
  bootseeds,
  outcome_type,
  intvars,
  interventions,
  int_times,
  ref_int,
  covparams,
  covnames,
  covtypes,
  covfits_custom,
  covpredict_custom,
  basecovs,
  histvars,
  histvals,
  histories,
  ymodel,
  yrestrictions,
  compevent_restrictions,
  restrictions,
  comprisk,
  compevent_model,
  time_name,
  outcome_name,
  compevent_name,
  ranges,
  parallel,
  ncores,
  max_visits,
  hazardratio,
  intcomp,
  boot_diag,
  nsimul,
  baselags,
  below_zero_indicator,
  min_time,
  show_progress,
  pb,
  int_visit_type
)
}
\arguments{
\item{r}{Integer specifying the index of the current iteration of the bootstrap.}

\item{time_points}{Number of time points to simulate.}

\item{obs_data}{Data table containing the observed data.}

\item{bootseeds}{Vector of integers specifying the seeds. One seed is used to initialize each bootstrap iteration.}

\item{outcome_type}{Character string specifying the "type" of the outcome. The possible "types" are: \code{"survival"}, \code{"continuous_eof"}, and \code{"binary_eof"}.}

\item{intvars}{List, whose elements are vectors of character strings. The kth vector in \code{intvars} specifies the name(s) of the variable(s) to be intervened
on in each round of the simulation under the kth intervention in \code{interventions}.}

\item{interventions}{List, whose elements are lists of vectors. Each list in \code{interventions} specifies a unique intervention on the relevant variable(s) in \code{intvars}. Each vector contains a function
implementing a particular intervention on a single variable, optionally
followed by one or more "intervention values" (i.e.,
integers used to specify the treatment regime).}

\item{int_times}{List, whose elements are lists of vectors. The kth list in \code{int_times} corresponds to the kth intervention in \code{interventions}. Each vector specifies the time points in which the relevant intervention is applied on the corresponding variable in \code{intvars}.
When an intervention is not applied, the simulated natural course value is used. By default, this argument is set so that all interventions are applied in all time points.}

\item{ref_int}{Integer denoting the intervention to be used as the
reference for calculating the risk ratio and risk difference. 0 denotes the
natural course, while subsequent integers denote user-specified
interventions in the order that they are
named in \code{interventions}.}

\item{covparams}{List of vectors, where each vector contains information for
one parameter used in the modeling of the time-varying covariates (e.g.,
model statement, family, link function, etc.). Each vector
must be the same length as \code{covnames} and in the same order.
If a parameter is not required for a certain covariate, it
should be set to \code{NA} at that index.}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates in \code{obs_data}.}

\item{covtypes}{Vector of character strings specifying the "type" of each time-varying covariate included in \code{covnames}. The possible "types" are: \code{"binary"}, \code{"normal"}, \code{"categorical"}, \code{"bounded normal"}, \code{"zero-inflated normal"}, \code{"truncated normal"}, \code{"absorbing"}, \code{"categorical time"}, and \code{"custom"}.}

\item{covfits_custom}{Vector containing custom fit functions for time-varying covariates that
do not fall within the pre-defined covariate types. It should be in
the same order \code{covnames}. If a custom fit function is not
required for a particular covariate (e.g., if the first
covariate is of type \code{"binary"} but the second is of type \code{"custom"}), then that
index should be set to \code{NA}.}

\item{covpredict_custom}{Vector containing custom prediction functions for time-varying
covariates that do not fall within the pre-defined covariate types.
It should be in the same order as \code{covnames}. If a custom
prediction function is not required for a particular
covariate, then that index should be set to \code{NA}.}

\item{basecovs}{Vector of character strings specifying the names of baseline covariates in \code{obs_data}.}

\item{histvars}{List of vectors. The kth vector specifies the names of the variables for which the kth history function
in \code{histories} is to be applied.}

\item{histvals}{List of length two. The first element is a numeric vector specifying the lags used in the model statements (e.g., if \code{lag1_varname} and \code{lag2_varname} were included in the model statements, this vector would be \code{c(1,2)}). The second element is a numeric vector specifying the lag averages used in the model statements.}

\item{histories}{Vector of history functions to apply to the variables specified in \code{histvars}.}

\item{ymodel}{Model statement for the outcome variable.}

\item{yrestrictions}{List of vectors. Each vector containins as its first entry
a condition and its second entry an integer. When the
condition is \code{TRUE}, the outcome variable is simulated
according to the fitted model; when the condition is \code{FALSE},
the outcome variable takes on the value in the second entry.}

\item{compevent_restrictions}{List of vectors. Each vector containins as its first entry
a condition and its second entry an integer. When the
condition is \code{TRUE}, the competing event variable is simulated
according to the fitted model; when the condition is \code{FALSE},
the competing event variable takes on the value in the
second entry.}

\item{restrictions}{List of vectors. Each vector contains as its first entry a covariate for which
\emph{a priori} knowledge of its distribution is available; its second entry a condition
under which no knowledge of its distribution is available and that must be \code{TRUE}
for the distribution of that covariate given that condition to be estimated via a parametric
model or other fitting procedure; its third entry a function for estimating the distribution
of that covariate given the condition in the second entry is false such that \emph{a priori} knowledge
of the covariate distribution is available; and its fourth entry a value used by the function in the
third entry. The default is \code{NA}.}

\item{comprisk}{Logical scalar indicating the presence of a competing event.}

\item{compevent_model}{Model statement for the competing event variable.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{outcome_name}{Character string specifying the name of the outcome variable in \code{obs_data}.}

\item{compevent_name}{Character string specifying the name of the competing event variable in \code{obs_data}.}

\item{ranges}{List of vectors. Each vector contains the minimum and
maximum values of one of the covariates in \code{covnames}.}

\item{parallel}{Logical scalar indicating whether to parallelize simulations of
different interventions to multiple cores.}

\item{ncores}{Integer specifying the number of cores to use in parallel
simulation.}

\item{max_visits}{A vector of one or more values denoting the maximum number of times
a binary covariate representing a visit process may be missed before
the individual is censored from the data (in the observed data) or
a visit is forced (in the simulated data). Multiple values exist in the
vector when the modeling of more than covariate is attached to a visit
process. A value of \code{NA} should be provided when there is no visit process.}

\item{hazardratio}{Logical scalar indicating whether the hazard ratio should be computed between two interventions.}

\item{intcomp}{List of two numbers indicating a pair of interventions to be compared by a hazard ratio.
The default is \code{NA}, resulting in no hazard ratio calculation.}

\item{boot_diag}{Logical scalar indicating whether to return the coefficients, standard errors, and variance-covariance matrices of the parameters of the fitted models in the bootstrap samples. The default is \code{FALSE}.}

\item{nsimul}{Number of subjects for whom to simulate data. By default, this argument is set
equal to the number of subjects in \code{obs_data}.}

\item{baselags}{Logical scalar for specifying the convention used for lagi and lag_cumavgi terms in the model statements when pre-baseline times are not
included in \code{obs_data} and when the current time index, \eqn{t}, is such that \eqn{t < i}. If this argument is set to \code{FALSE}, the value
of all lagi and lag_cumavgi terms in this context are set to 0 (for non-categorical covariates) or the reference
level (for categorical covariates). If this argument is set to \code{TRUE}, the value of lagi and lag_cumavgi terms
are set to their values at time 0. The default is \code{FALSE}.}

\item{below_zero_indicator}{Logical scalar indicating whether the observed data set contains rows for time \eqn{t < 0}.}

\item{min_time}{Numeric scalar specifying lowest value of time \eqn{t} in the observed data set.}

\item{show_progress}{Logical scalar indicating whether to print a progress bar for the number of bootstrap samples completed in the R console. This argument is only applicable when \code{parallel} is set to \code{FALSE} and bootstrap samples are used (i.e., \code{nsamples} is set to a value greater than 0). The default is \code{TRUE}.}

\item{pb}{Progress bar R6 object. See \code{\link[progress]{progress_bar}} for further details.}

\item{int_visit_type}{Vector of logicals. The kth element is a logical specifying whether to carry forward the intervened value (rather than the natural value) of the treatment variables(s) when performing a carry forward restriction type for the kth intervention in \code{interventions}.
When the kth element is set to \code{FALSE}, the natural value of the treatment variable(s) in the kth intervention in \code{interventions} will be carried forward.
By default, this argument is set so that the intervened value of the treatment variable(s) is carried forward for all interventions.}
}
\value{
A list with the following components:
\item{Result}{Matrix containing risks over time under the natural course and under each user-specific intervention.}
\item{ResultRatio}{Matrix containing risk ratios over time under the natural course and under each user-specific intervention.}
\item{ResultDiff}{Matrix containing risk differences over time under the natural course and under each user-specific intervention.}
\item{bootcoeffs}{List of the coefficients of the fitted models. If the argument \code{boot_diag} is set to \code{FALSE}, a value of \code{NA} is given.}
\item{bootstderrs}{List of the standard errors of the coefficients of the fitted models. If the argument \code{boot_diag} is set to \code{FALSE}, a value of \code{NA} is given.}
}
\description{
This internal function bootstraps the observed data (i.e., resamples the observed data set with replacement to
construct bootstrap confidence intervals and standard errors). Then, the function simulates data
using the resampled dataset to estimate the survival outcome, binary end-of-follow-up outcome, or
continuous end-of-follow-up outcome.
}
\keyword{internal}
