% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataFunctions.R
\name{dataGenerator}
\alias{dataGenerator}
\title{Data Generator}
\usage{
dataGenerator(n, changepoints, parameters, type = "mean", sigma = 1,
  gamma = 1, size = 10)
}
\arguments{
\item{n}{number of data points to generate}

\item{changepoints}{vector of position of the changepoints in (0,1] (last element is always 1).}

\item{parameters}{vector of means for the consecutive segments (same length as changepoints)}

\item{type}{a string defining the cost model to use: "mean", "variance", "poisson", "exp", "negbin"}

\item{sigma}{a positive number = the standard deviation of the data}

\item{gamma}{a number between 0 and 1 : the coefficient of the exponential decay (by default = 1 for piecewise constant signals)}

\item{size}{parameter of the rnbinom function}
}
\value{
a vector of size n generated by the chosen model
}
\description{
Generating data with a given model = changepoint relative positions + parameters + type of cost + (standard deviation + gamma decay)
}
\examples{
dataGenerator(100, c(0.3, 0.6, 1), c(1, 2, 3))
}
