% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qmap.R
\name{qmap}
\alias{qmap}
\title{Quick map}
\usage{
qmap(
  data,
  ...,
  x = NULL,
  y = NULL,
  geom = "point",
  limits = NULL,
  shapefiles = NULL,
  crs = NULL,
  bathymetry = FALSE,
  glaciers = FALSE,
  rotate = FALSE,
  legends = TRUE,
  legend.position = "right",
  lon.interval = NULL,
  lat.interval = NULL,
  bathy.style = NULL,
  bathy.border.col = NA,
  bathy.size = 0.1,
  land.col = "grey60",
  land.border.col = "black",
  land.size = 0.1,
  gla.col = "grey95",
  gla.border.col = "black",
  gla.size = 0.1,
  grid.col = "grey70",
  grid.size = 0.1,
  base_size = 11,
  projection.grid = FALSE,
  expand.factor = 1.1,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame to use.}

\item{x, y, ...}{Aesthetics passed into each layer. Longitude and latitude columns are automatically recognized using the \code{\link{guess_coordinate_columns}} function.}

\item{geom}{Character argument specifying geom(s) to draw. Defaults to "point". Other alternatives are "text" and "label". The "text" option can also be triggered by simply mapping a variable to \code{label} (see Examples).}

\item{limits}{Map limits. One of the following:
\itemize{
  \item \strong{numeric vector} of length 4: The first element defines the start longitude, the second element the end longitude (counter-clockwise), the third element the minimum latitude, and the fourth element the maximum latitude of the bounding box. Also accepts \code{\link[sf:st_bbox]{sf::st_bbox}} type named vectors with limits in any order. The coordinates can be given as decimal degrees or coordinate units for shapefiles used by a projected map. Produces a rectangular map. Latitude limits not given in min-max order are automatically ordered to respect this requirement.
  \item \strong{single integer} between 30 and 88 or -88 and -30 produces a polar map for the Arctic or Antarctic, respectively.
}
Can be omitted if \code{data} or \code{shapefiles} are defined.}

\item{shapefiles}{Either a \link[=shapefile_list]{list containing shapefile information} or a character argument referring to a name of pre-made shapefiles in \code{\link{shapefile_list}}. This name is partially matched. Can be omitted if \code{limits} or \code{data} is defined as decimal degrees.}

\item{crs}{\link[sf:st_crs]{Coordinate reference system} (CRS) for the map. If \code{NULL} (default), the CRS is selected automatically based on \code{limits}, \code{data}, or \code{shapefiles}. Passed to \code{\link[sf]{st_crs}}. Typically integers giving the EPGS code are the easiest. Cannot be used simultaneously with \code{rotate}.}

\item{bathymetry}{Logical indicating whether bathymetry should be added to the map. Functions together with \code{bathy.style}. See Details.}

\item{glaciers}{Logical indicating whether glaciers and ice sheets should be added to the map.}

\item{rotate}{Logical indicating whether the projected maps should be rotated to point towards the pole relative to the mid-longitude limit.}

\item{legends}{Logical indicating whether the legend for bathymetry should be shown.}

\item{legend.position}{The position for ggplot2 legend. See the argument with the same name in \link[ggplot2]{theme}.}

\item{lon.interval, lat.interval}{Numeric value specifying the interval of longitude and latitude grids. \code{NULL} finds reasonable defaults depending on \code{limits}.}

\item{bathy.style}{Character (plots bathymetry; list of alternatives in Details) or \code{NULL} ("raster_binned_blues" if \code{bathymetry = TRUE}) defining the bathymetry style. Partially matched, can be abbreviated, and used to control bathymetry plotting together with \code{bathymetry}. See Details.}

\item{land.col, gla.col, grid.col}{Character code specifying the color of land, glaciers, and grid lines, respectively. Use \code{NA} to remove the grid lines.}

\item{land.border.col, gla.border.col, bathy.border.col}{Character code specifying the color of the border line for land, glacier, and bathymetry shapes.}

\item{land.size, gla.size, bathy.size, grid.size}{Numeric value specifying the width of the border line land, glacier and bathymetry shapes as well as the grid lines, respectively. Use the \code{\link{LS}} function for a specific width in pt. See Details.}

\item{base_size}{Base size parameter for ggplot. See \link[ggplot2]{ggtheme}.}

\item{projection.grid}{Logical indicating whether the coordinate grid should show projected coordinates instead of decimal degree values. Useful to define limits for large maps in polar regions.}

\item{expand.factor}{Expansion factor for map limits with the \code{data} argument. Can be used to zoom in and out automatically limited maps. Defaults to 1.1. Set to \code{NULL} to ignore.}

\item{verbose}{Logical indicating whether information about the projection and guessed column names should be returned as messages. Set to \code{FALSE} to make the function silent.}
}
\value{
Returns a \link[ggplot2]{ggplot} map, which can be assigned to an object and modified as any ggplot object.
}
\description{
\code{qmap} is a shortcut similar to ggplot2's \code{\link[ggplot2]{qplot}} designed to quickly plot data with a limited range of options.
}
\examples{
dt <- data.frame(lon = c(-100, -80, -60), lat = c(10, 25, 40), var = c("a", "a", "b"))

# Quickly see position of data
qmap(dt)

\donttest{
# Set color
qmap(dt, color = I("blue")) 

# Map color to a variable
qmap(dt, color = var) 
 
# Map text to a variable 
qmap(dt, label = var) 

# All basemap arguments work in qmap()
dt <- data.frame(lon = c(-80, -80, -50, -50), lat = c(65, 80, 80, 65))
qmap(dt, rotate = TRUE)
}
}
\seealso{
Other basemap functions: 
\code{\link{basemap}()},
\code{\link{shapefile_list}()},
\code{\link{transform_coord}()}
}
\author{
Mikko Vihtakari
}
\concept{basemap functions}
