% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_Violations.R
\name{QC_Violations}
\alias{QC_Violations}
\title{Calculate QC Violations}
\usage{
QC_Violations(data, value = NULL, grouping = NULL, formula = NULL,
  method = NULL, ...)
}
\arguments{
\item{data}{vector or dataframe, as indicated below for each chart type
\itemize{
\item \bold{Individuals}: vector of values;
\item \bold{Studentized Charts}: dataframe
}}

\item{value}{\bold{Studentized Charts}: numeric vector in dataframe with values of interest}

\item{grouping}{\bold{Studentized Charts}: single factor/variable to split
the dataframe "values" by}

\item{formula}{\bold{Studentized Charts}: a formula,
such as y ~ x1 + x2, where the y variable is
numeric data to be split into groups according to the grouping x
factors/variables}

\item{method}{string, calling the following methods:
\itemize{
  \item \bold{Individuals Charts}: XmR,
  \item \bold{Studentized Charts}: xBar.rBar, xBar.rMedian, xBar.sBar, xMedian.rBar,
xMedian.rMedian
}}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a dataframe, with the following columns
\itemize{
\item \bold{data}: The input data if XmR, mean or median by group for Studentized methods
\item \bold{z_score}: z-score for the data point
\item \bold{Index}: number, indicating the order of the input data
\item \bold{Violation_Result}: description of the type of test being run.
   \itemize{
    \item \bold{Violation Same Side:} 8 or more consecutive, same-side points
    \item \bold{Violation 1 Sigma:} 4 or more consecutive, same-side points exceeding 1 sigma
    \item \bold{Violation 2 Sigma:} 2 or more consecutive, same-side points exceeding 2 sigma
    \item \bold{Violation 3 Sigma:} any points exceeding 3 sigma
    }
\item \bold{Index}: boolean, does the data point violate the rule?
}
}
\description{
function that calculates QC violations on sequentially ordered data
based on the following 4 rules:
\itemize{
\item \bold{Violation Same Side:} 8 or more consecutive, same-side points
\item \bold{Violation 1 Sigma:} 4 or more consecutive, same-side points exceeding 1 sigma
\item \bold{Violation 2 Sigma:} 2 or more consecutive, same-side points exceeding 2 sigma
\item \bold{Violation 3 Sigma:} any points exceeding 3 sigma
}
}
\note{
If using the \bold{formula} argument do not use \bold{value} and \bold{group} arguments.
}
\examples{
#####################################
#  Example 1: XmR Check Violations  #
#####################################
# Load Libraries ----------------------------------------------------------
 require(ggQC)

# Setup Data --------------------------------------------------------------

    set.seed(5555)
    QC_XmR <- data.frame(
    data = c(c(-1, 2.3, 2.4, 2.5),                        #Outlier Data
          sample(c(rnorm(60),5,-5), 62, replace = FALSE), #Normal Data
          c(1,-.3, -2.4,-2.6,-2.5,-2.7, .3)),             #Outlier Data
    Run_Order = 1:73                                      #Run Order
    )

   QC_Vs <- QC_Violations(data  = QC_XmR$data, method = "XmR")

#######################################
#  Example 2: Xbar Check Violations   #
#######################################

# Setup Some Data ------------------------------------------------------------
     QC_xBar.rBar <- do.call(rbind, lapply(1:3, function(X){
       set.seed(5555+X)                                   #Loop over 3 seeds
       data.frame(
         sub_group = rep(1:42),                           #Define Subgroups
         sub_class = letters[X],
         c(
          c(runif(n = 5, min = 2.0,3.2)),                 #Outlier Data
          sample(c(rnorm(30),5,-4), 32, replace = FALSE), #Normal Data
          c(runif(n = 5, min = -3.2, max = -2.0))         #Outlier Data
         )
      )
     }
   )
)

colnames(QC_xBar.rBar) <- c("sub_group","sub_class", "value")
QC_Vs <- QC_Violations(data  = QC_xBar.rBar,
                       formula = value~sub_group,
                       method = "xBar.rBar")
}
\references{
Wheeler, DJ, and DS Chambers. Understanding Statistical Process Control, 2nd Ed. Knoxville, TN: SPC, 1992. Print.
}
