% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calc_roc.rfsrc}
\alias{calc_roc}
\alias{calc_roc.randomForest}
\alias{calc_roc.rfsrc}
\title{Internal Reciever Operator Characteristic calculator for randomForest objects}
\usage{
calc_roc.rfsrc(rf, dta, which.outcome = "all", oob = TRUE)
}
\arguments{
\item{rf}{\code{randomForestSRC::rfsrc} or \code{randomForestSRC::predict} object
containing predicted response}

\item{dta}{True response variable}

\item{which.outcome}{If defined, only show ROC for this response.}

\item{oob}{Use OOB estimates, the normal validation method (TRUE)}
}
\description{
Internal Reciever Operator Characteristic calculator for randomForest objects
}
\details{
Given the randomForest or randomForestSRC prediction and the actual
response value, calculate the specificity (1-False Positive Rate) and sensitivity
(True Positive Rate) of a predictor.

This is a helper function for the \code{\link{gg_roc}} functions, and not intended
for use by the end user.
}
\examples{
\dontrun{
##
## Taken from the gg_roc example
iris.obj <- rfsrc(Species ~ ., data = iris)
roc <- calc_roc.rfsrc(iris.obj, iris.obj$yvar, which.outcome=1, oob=TRUE)
}
}
\seealso{
\code{\link{calc_auc}} \code{\link{gg_roc}} \code{\link{plot.gg_roc}}
}

