% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_survival}
\alias{plot.gg_survival}
\title{Plot a \code{\link{gg_survival}} or a survival \code{\link{gg_rfsrc}} object.}
\usage{
\method{plot}{gg_survival}(x, error = c("shade", "bars", "lines"), ...)
}
\arguments{
\item{x}{code{\link{gg_survival}} or a survival \code{\link{gg_rfsrc}} object created from a
\code{randomForestSRC::rfsrc} object}

\item{error}{"shade", "bars" or "lines"}

\item{...}{not used}
}
\value{
\code{ggplot} object
}
\description{
Plot a \code{\link{gg_survival}} or a survival \code{\link{gg_rfsrc}} object.
}
\examples{
\dontrun{
## veteran data
## randomized trial of two treatment regimens for lung cancer
#data(veteran, package = "randomForestSRCM")
#veteran_rf <- rfsrc(Surv(time, status) ~ ., data = veteran, ntree = 100)

ggrf.obj <- gg_survival(veteran_rf)
plot(ggrf.obj)
}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R,
Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival,
Regression and Classification (RF-SRC), R package version 1.4.
}

