% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gg_partial.ggRandomForests.R
\name{gg_partial}
\alias{gg_partial}
\alias{gg_partial.ggRandomForests}
\alias{gg_partial_list}
\title{Partial variable dependence object}
\usage{
gg_partial.ggRandomForests(object, named, ...)
}
\arguments{
\item{object}{the partial variable dependence data object from
\code{randomForestSRC::plot.variable} function}

\item{named}{optional column for merging multiple plots together}

\item{...}{optional arguments}
}
\value{
\code{gg_partial} object. A \code{data.frame} or \code{list} of
\code{data.frames} corresponding the variables
contained within the \code{randomForestSRC::plot.variable} output.
}
\description{
The \code{randomForestSRC::plot.variable} function returns a
list of either marginal variable dependance or partial variable dependence
data from a \code{randomForestSRC::rfsrc} object.
The \code{gg_partial} function formulates the \code{randomForestSRC::plot.variable} output
for partial plots  (where \code{partial=TRUE}) into a data object for creation of
partial dependence plots using the \code{\link{plot.gg_partial}} function.

Partial variable dependence plots are the risk adjusted estimates of the specified
response as a function of a single covariate, possibly subsetted on other covariates.
}
\examples{
## ------------------------------------------------------------
## classification
## ------------------------------------------------------------

## iris "Petal.Width" partial dependence plot
##
# rfsrc_iris <- rfsrc(Species ~., data = iris)
# partial_iris <- plot.variable(rfsrc_iris, xvar.names = "Petal.Width",
#                            partial=TRUE)
data(partial_iris, package="ggRandomForests")

gg_dta <- gg_partial(partial_iris)
plot(gg_dta)

## ------------------------------------------------------------
## regression
## ------------------------------------------------------------

## airquality "Wind" partial dependence plot
##
# rfsrc_airq <- rfsrc(Ozone ~ ., data = airquality)
# partial_airq <- plot.variable(rfsrc_airq, xvar.names = "Wind",
#                            partial=TRUE, show.plot=FALSE)
data(partial_airq, package="ggRandomForests")

gg_dta <- gg_partial(partial_airq)
plot(gg_dta)

## ------------------------------------------------------------
## survival examples
## ------------------------------------------------------------
## survival "age" partial variable dependence plot
##
# data(veteran, package = "randomForestSRC")
# rfsrc_veteran <- rfsrc(Surv(time,status)~., veteran, nsplit = 10, ntree = 100)
#
## 30 day partial plot for age
# partial_veteran <- plot.variable(rfsrc_veteran, surv.type = "surv",
#                               partial = TRUE, time=30,
#                               xvar.names = "age",
#                               show.plots=FALSE)
data(partial_veteran, package="ggRandomForests")

gg_dta <- gg_partial(partial_veteran[[1]])
plot(gg_dta)
}
\references{
Friedman, Jerome H. 2000. "Greedy Function Approximation: A Gradient Boosting
Machine." Annals of Statistics 29: 1189-1232.
}
\seealso{
\code{\link{plot.gg_partial}} \code{randomForestSRC::plot.variable}
}

