% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gg_roc.ggRandomForests.R
\name{gg_roc.ggRandomForests}
\alias{gg_roc}
\alias{gg_roc.ggRandomForests}
\title{ROC (Receiver operator curve) data from a classification random forest.}
\usage{
gg_roc.ggRandomForests(object, which.outcome, oob = TRUE)
}
\arguments{
\item{object}{an \code{randomForestSRC::rfsrc} classification object}

\item{which.outcome}{select the classification outcome of interest.}

\item{oob}{use oob estimates (default TRUE)}
}
\value{
\code{gg_roc} \code{data.frame} for plotting ROC curves.
}
\description{
The sensitivity and specificity of a randomForests classification object.
}
\examples{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
#rfsrc_iris <- rfsrc(Species ~ ., data = iris)
data(rfsrc_iris, package="ggRandomForests")

# ROC for setosa
gg_dta <- gg_roc(rfsrc_iris, which.outcome=1)
plot.gg_roc(gg_dta)

# ROC for versicolor
gg_dta <- gg_roc(rfsrc_iris, which.outcome=2)
plot.gg_roc(gg_dta)

# ROC for virginica
gg_dta <- gg_roc(rfsrc_iris, which.outcome=3)
plot.gg_roc(gg_dta)

# Alternatively, you can plot all three outcomes in one go
# by calling the plot function on the forest object.
plot.gg_roc(rfsrc_iris)
}
\seealso{
\code{\link{plot.gg_roc}} \code{randomForestSRC::rfsrc}
}

