% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-dendrogram.R
\name{align_dendro}
\alias{align_dendro}
\title{Reorder or Group layout based on hierarchical clustering}
\usage{
align_dendro(
  mapping = aes(),
  ...,
  distance = "euclidean",
  method = "complete",
  use_missing = "pairwise.complete.obs",
  reorder_dendrogram = FALSE,
  merge_dendrogram = FALSE,
  reorder_group = FALSE,
  k = NULL,
  h = NULL,
  plot_dendrogram = TRUE,
  plot_cut_height = NULL,
  root = NULL,
  center = FALSE,
  type = "rectangle",
  size = NULL,
  free_guides = waiver(),
  free_spaces = waiver(),
  plot_data = waiver(),
  theme = waiver(),
  free_labs = waiver(),
  data = NULL,
  set_context = NULL,
  order = NULL,
  name = NULL
)
}
\arguments{
\item{mapping}{Additional default list of aesthetic mappings to use for plot.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> Additional arguments passed to
\link[ggplot2:geom_segment]{geom_segment()}.}

\item{distance}{A string of distance measure to be used. This must be one of
\code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or
\code{"minkowski"}.  Correlation coefficient can be also used, including
\code{"pearson"}, \code{"spearman"} or \code{"kendall"}. In this way, \code{1 - cor} will be used
as the distance. In addition, you can also provide a \link[stats:dist]{dist}
object directly or a function return a \link[stats:dist]{dist} object. Use
\code{NULL}, if you don't want to calculate the distance.}

\item{method}{A string of the agglomeration method to be used. This should be
(an unambiguous abbreviation of) one of \code{"ward.D"}, \code{"ward.D2"}, \code{"single"},
\code{"complete"}, \code{"average"} (= UPGMA), \code{"mcquitty"} (= WPGMA), \code{"median"} (=
WPGMC) or \code{"centroid"} (= UPGMC). You can also provide a function which
accepts the distance and returns a \link[stats:hclust]{hclust} object.
Alternative, you can supply an object which can be coerced to
\link[stats:hclust]{hclust}.}

\item{use_missing}{An optional character string giving a method for computing
covariances in the presence of missing values. This must be (an abbreviation
of) one of the strings \code{"everything"}, \code{"all.obs"}, \code{"complete.obs"},
\code{"na.or.complete"}, or \code{"pairwise.complete.obs"}. Only used when \code{distance}
is a correlation coefficient string.}

\item{reorder_dendrogram}{A single boolean value, indicates whether we should
reorder the dendrogram based on the means. Default: \code{FALSE}.}

\item{merge_dendrogram}{A single boolean value, indicates whether we should
merge multiple dendrograms, only used when previous groups have been
established. Default: \code{FALSE}.}

\item{reorder_group}{A single boolean value, indicates whether we should do
Hierarchical Clustering between groups, only used when previous groups have
been established. Default: \code{FALSE}.}

\item{k}{An integer scalar indicates the desired number of groups.}

\item{h}{A numeric scalar indicates heights where the tree should be cut.}

\item{plot_dendrogram}{A boolean value indicates whether plot the dendrogram
tree.}

\item{plot_cut_height}{A boolean value indicates whether plot the cut height.}

\item{root}{A length one string or numeric indicates the root branch.}

\item{center}{A boolean value. if \code{TRUE}, nodes are plotted centered with
respect to the leaves in the branch. Otherwise (default), plot them in the
middle of all direct child nodes.}

\item{type}{A string indicates the plot type, \code{"rectangle"} or \code{"triangle"}.}

\item{size}{Plot size, can be an \link[grid:unit]{unit} object.}

\item{free_guides}{Override the \code{guides} argument specified in the layout for
a plot. Options include:
\itemize{
\item \code{\link[ggplot2:waiver]{waiver()}}: inherits behavior from the layout.
\item \code{NULL}: no guide legends will be collected for the plot.
\item A string containing one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"} indicates which side of guide legends should be collected for the plot..
}}

\item{free_spaces}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"}
indicating which border spaces should be removed. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If no
parent, the default is \code{NULL}, meaning no spaces are removed.}

\item{plot_data}{A function to transform plot data before rendering. Defaults
to \code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If
no parent layout, the default is \code{NULL}, meaning the data won't be modified.

Used to modify the data after layout has been created, which should be a data
frame, but before the data is handled of to the ggplot2 for rendering. Use
this hook if the you needs change the default data for all \code{geoms}.}

\item{theme}{Default plot theme: One of:
\itemize{
\item \code{\link[ggplot2:waiver]{waiver()}}: will inherit from the parent layout.
\item \code{NULL}: Use the \link[=theme_ggalign]{default theme}.
\item \code{\link[ggplot2:theme]{theme()}}: will be added with the parent layout theme.
}

\verb{Note:} The axis title and labels parallel to the layout axis will always be
removed by default. For vertical stack layouts, this refers to the \code{x-axis},
and for horizontal stack layouts, this refers to the \code{y-axis}. If you want to
display the axis title or labels, you should manually add
\link[ggplot2:theme]{theme()} elements for the parallel axis title or labels.}

\item{free_labs}{A string with one or more of \code{"t"}, \code{"l"}, \code{"b"}, and \code{"r"} indicating
which axis titles should be free from alignment. Defaults to
\code{\link[ggplot2:waiver]{waiver()}}, which inherits from the parent layout. If no
parent layout, no axis titles will be aligned. If \code{NULL}, all axis titles
will be aligned.}

\item{data}{A matrix, data frame, or a simple vector. If an atomic vector is
provided, it will be converted into a one-column matrix. When \code{data = NULL},
the internal \code{layout} data will be used by default. Additionally, \code{data} can
be a function (including purrr-like lambdas), which will be applied to the
\code{layout} data.

It is important to note that we consider the \code{rows} as the observations. It
means the \code{NROW(data)} must return the same number with the specific \code{layout}
axis (meaning the x-axis for vertical stack layout, or y-axis for horizontal
stack layout).
\itemize{
\item \code{heatmap_layout()}: for column annotation, the \code{layout} data will be
transposed before using (If data is a \code{function}, it will be applied with
the transposed matrix). This is necessary because column annotation uses
heatmap columns as observations, but we need rows.
\item \code{stack_layout()}: the \code{layout} data will be used as it is since we place
all plots along a single axis.
}}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{order}{An single integer for the plot area order.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A new \code{Align} object.
}
\description{
Reorder or Group layout based on hierarchical clustering
}
\section{ggplot2 specification}{

\code{align_dendro} initializes a ggplot \code{data} and \code{mapping}.

The internal will always use a default mapping of \code{aes(x = .data$x, y = .data$y)}.

The default ggplot data is the \code{node} coordinates, in addition, a
\link[ggplot2:geom_segment]{geom_segment} layer with a data of the tree segments
\code{edge} coordinates will be added.

\code{node} and tree segments \code{edge} coordinates contains following columns:
\itemize{
\item \code{index}: the original index in the tree for the current node
\item \code{label}: node label text
\item \code{x} and \code{y}: x-axis and y-axis coordinates for current node or the start
node of the current edge.
\item \code{xend} and \code{yend}: the x-axis and y-axis coordinates of the terminal node
for current edge.
\item \code{branch}: which branch current node or edge is. You can use this column
to color different groups.
\item \code{panel}: which panel current node is, if we split the plot into panel
using \link[ggplot2:facet_grid]{facet_grid}, this column will show
which panel current node or edge is from. Note: some nodes may
fall outside panel (between two panel), so there are possible
\code{NA} values in this column.
\item \code{.panel}: Similar with \code{panel} column, but always give the correct branch
for usage of the ggplot facet.
\item \code{panel1} and \code{panel2}: The panel1 and panel2 variables have the same
functionality as \code{panel}, but they are specifically for the \code{edge} data
and correspond to both nodes of each edge.
\item \code{leaf}: A logical value indicates whether current node is a leaf.
}
}

\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    align_dendro()
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    align_dendro(k = 3L)
}
\seealso{
\itemize{
\item \code{\link[=dendrogram_data]{dendrogram_data()}}
\item \code{\link[=hclust2]{hclust2()}}
}
}
