% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-data-frame.R
\name{fortify_data_frame.character}
\alias{fortify_data_frame.character}
\alias{fortify_data_frame.numeric}
\alias{fortify_data_frame.logical}
\alias{fortify_data_frame.complex}
\title{Build a data frame}
\usage{
\method{fortify_data_frame}{character}(data, ..., data_arg = caller_arg(data), call = NULL)

\method{fortify_data_frame}{numeric}(data, ..., data_arg = caller_arg(data), call = NULL)

\method{fortify_data_frame}{logical}(data, ..., data_arg = caller_arg(data), call = NULL)

\method{fortify_data_frame}{complex}(data, ..., data_arg = caller_arg(data), call = NULL)
}
\arguments{
\item{data}{An object to be converted to a data frame.}

\item{...}{These dots are for future extensions and must be empty.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected, e.g., \code{\link[rlang:stack]{caller_env()}}.
Developers can use it to improve messages. Not used by the user.}
}
\value{
A data frame with following columns:
\itemize{
\item \code{.names}: the names for the vector (only applicable if names exist).
\item \code{value}: the actual value of the vector.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function converts various objects to a data frame.
}
\seealso{
Other fortify_data_frame methods: 
\code{\link{fortify_data_frame.default}()},
\code{\link{fortify_data_frame.dendrogram}()},
\code{\link{fortify_data_frame.matrix}()},
\code{\link{fortify_data_frame.phylo}()}
}
\concept{fortify_data_frame methods}
