% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-draw2.R
\name{geom_draw2}
\alias{geom_draw2}
\title{Layer with customized draw function}
\usage{
geom_draw2(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Additional arguments passed on to \code{draw} aesthetic.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
Layer with customized draw function
}
\details{
\code{geom_draw2} depends on the new aesthetics \code{draw}, which should always be
provided with \code{\link[=scale_draw_manual]{scale_draw_manual()}}, in which, we can provide a list of
functions that define how each value should be drawn. Any ggplot2 aesthetics
can be used as the arguments.
}
\section{Aesthetics}{

\code{geom_draw2()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{draw}}
\item \code{\link[ggplot2:aes_colour_fill_alpha]{alpha}}
\item \code{\link[ggplot2:aes_colour_fill_alpha]{colour}}
\item \code{\link[ggplot2:aes_colour_fill_alpha]{fill}}
\item \code{\link[ggplot2:aes_group_order]{group}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{linetype}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{linewidth}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{shape}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{size}}
\item \code{stroke}
\item \code{\link[ggplot2:aes_position]{x}}
\item \code{\link[ggplot2:aes_position]{y}}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs", package = "ggplot2")}.
}

\examples{
library(grid)
ggplot(data.frame(value = letters[seq_len(5)], y = seq_len(5))) +
    geom_draw2(aes(x = 1, y = y, draw = value, fill = value)) +
    scale_draw_manual(values = list(
        a = function(x, y, width, height, fill) {
            rectGrob(x, y,
                width = width, height = height,
                gp = gpar(fill = fill),
                default.units = "native"
            )
        },
        b = function(x, y, width, height, fill) {
            rectGrob(x, y,
                width = width, height = height,
                gp = gpar(fill = fill),
                default.units = "native"
            )
        },
        c = function(x, y, width, height, fill) {
            rectGrob(x, y,
                width = width, height = height,
                gp = gpar(fill = fill),
                default.units = "native"
            )
        },
        d = function(x, y, width, height, shape) {
            gList(
                pointsGrob(x, y, pch = shape),
                # To ensure the rectangle color is shown in the legends, you
                # must explicitly provide a color argument and include it in
                # the `gpar()` of the graphical object
                rectGrob(x, y, width, height,
                    gp = gpar(col = "black", fill = NA)
                )
            )
        },
        e = function(xmin, xmax, ymin, ymax) {
            segmentsGrob(
                xmin, ymin,
                xmax, ymax,
                gp = gpar(lwd = 2)
            )
        }
    )) +
    scale_fill_brewer(palette = "Dark2") +
    theme_void()

}
