% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_bkde.r
\name{geom_bkde}
\alias{geom_bkde}
\alias{stat_bkde}
\title{Display a smooth density estimate.}
\usage{
geom_bkde(mapping = NULL, data = NULL, stat = "bkde",
  position = "identity", bandwidth = NULL, range.x = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)

stat_bkde(mapping = NULL, data = NULL, geom = "area",
  position = "stack", kernel = "normal", canonical = FALSE,
  bandwidth = NULL, gridsize = 410, range.x = NULL, truncate = TRUE,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{bandwidth}{the kernel bandwidth smoothing parameter. see
\code{\link[KernSmooth]{bkde}} for details. If \code{NULL},
it will be computed for you but will most likely not yield optimal
results.}

\item{range.x}{vector containing the minimum and maximum values of x at which
to compute the estimate. see \code{\link[KernSmooth]{bkde}} for details}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{geom, stat}{Use to override the default connection between
\code{geom_bkde} and \code{stat_bkde}.}

\item{kernel}{character string which determines the smoothing kernel. see
\code{\link[KernSmooth]{bkde}} for details}

\item{canonical}{logical flag: if TRUE, canonically scaled kernels are used.
see \code{\link[KernSmooth]{bkde}} for details}

\item{gridsize}{the number of equally spaced points at which to estimate the
density. see \code{\link[KernSmooth]{bkde}} for details.}

\item{truncate}{logical flag: if TRUE, data with x values outside the range
specified by range.x are ignored. see \code{\link[KernSmooth]{bkde}}
for details}
}
\description{
A kernel density estimate, useful for displaying the distribution of
variables with underlying smoothness.
}
\details{
\if{html}{
A sample of the output from \code{geom_bkde()}:

\figure{geombkde01.png}{options: width="100\%" alt="Figure: geombkde01.png"}
}

\if{latex}{
A sample of the output from \code{geom_bkde()}:

\figure{geombkde01.png}{options: width=10cm}
}
}
\section{Aesthetics}{

\code{geom_bkde} understands the following aesthetics (required aesthetics
are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \code{alpha}
  \item \code{color}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
}
}

\section{Computed variables}{

\describe{
  \item{density}{density estimate}
  \item{count}{density * number of points - useful for stacked density
     plots}
  \item{scaled}{density estimate, scaled to maximum of 1}
}
}

\examples{
data(geyser, package="MASS")

ggplot(geyser, aes(x=duration)) +
  stat_bkde(alpha=1/2)

ggplot(geyser, aes(x=duration)) +
  geom_bkde(alpha=1/2)

ggplot(geyser, aes(x=duration)) +
 stat_bkde(bandwidth=0.25)

ggplot(geyser, aes(x=duration)) +
  geom_bkde(bandwidth=0.25)
}
\seealso{
See \code{\link{geom_histogram}}, \code{\link{geom_freqpoly}} for
  other methods of displaying continuous distribution.
  See \code{\link{geom_violin}} for a compact density display.
}
