% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-zoom.R, R/view-zoom-manual.R
\name{view_zoom}
\alias{view_zoom}
\alias{view_zoom_manual}
\title{Pan and zoom smoothly between different states}
\usage{
view_zoom(pause_length = 1, step_length = 1, nsteps = NULL,
  look_ahead = 0, delay = 0, include = FALSE, pan_zoom = 0,
  ease = "sine-in-out", wrap = TRUE, pause_first = TRUE,
  fixed_x = FALSE, fixed_y = FALSE, exclude_layer = NULL,
  aspect_ratio = 1)

view_zoom_manual(pause_length = 1, step_length = 1, xmin, xmax, ymin,
  ymax, delay = 0, pan_zoom = 0, ease = "sine-in-out", wrap = TRUE,
  pause_first = TRUE, fixed_x = FALSE, fixed_y = FALSE,
  exclude_layer = NULL, aspect_ratio = 1)
}
\arguments{
\item{pause_length}{The relative length the view will be kept static. Will
be recycled to match the number of steps}

\item{step_length}{The relative length the view will use to transition to the
new position. Will be recycled to match the number of steps}

\item{nsteps}{The number of steps. If \code{NULL} it will be set to the max length
of \code{pause_length} or \code{step_length}}

\item{look_ahead}{A relative length to look ahead in the animation to get the
new zoom area. Allow the view to zoom to where the data will be}

\item{delay}{A relative length to switch the view back and forth relative to
the actual frames. E.g. if delay is calculated to 5 frames, frame 6 will get
the view intended for frame 1.}

\item{include}{Should the steps include both the start and end frame range}

\item{pan_zoom}{The tradeoff between pan- and zoom-induced movement. Negative
values will value zoom over pan and positive values will value pan over zoom}

\item{ease}{The easing function used for the step}

\item{wrap}{As in \code{\link[=transition_states]{transition_states()}}. Should the view wrap around and zoom
back to the first state.}

\item{pause_first}{Should the view start with a pause. The default is to
start with a step so that it is aligned to the static period in
\code{\link[=transition_states]{transition_states()}}}

\item{fixed_x}{Either a logical indicating if the dimension should
not be modified by the view, or a numeric vector giving the lower and upper
bounds of the dimension. For the latter, an \code{NA} value will be substituted
for whatever is calculated by the view (e.g. \code{fixed_x = c(0, NA)}) will fix
the minimum x value to 0 and let the view calculate the upper bound.}

\item{fixed_y}{Either a logical indicating if the dimension should
not be modified by the view, or a numeric vector giving the lower and upper
bounds of the dimension. For the latter, an \code{NA} value will be substituted
for whatever is calculated by the view (e.g. \code{fixed_x = c(0, NA)}) will fix
the minimum x value to 0 and let the view calculate the upper bound.}

\item{exclude_layer}{Integer vector of layer indices that should be ignored
when calculating the view}

\item{aspect_ratio}{If the coord is fixed, ensure that the view matches the
given aspect ratio. Will override anything given in \code{fixed_x}/\code{fixed_y}}

\item{xmin, xmax, ymin, ymax}{Vectors of even length defining the boundaries of
the different views to go through}
}
\description{
This view is in many ways equivalent to \code{\link[=view_step]{view_step()}} and
\code{\link[=view_step_manual]{view_step_manual()}} but instead of simply tweening the bounding box of each
view it implement the smooth zoom and pan technique developed by Reach &
North (2018). It gradually zooms out and then in during the pan to allow a
smooth transition of the view. As with \code{\link[=view_step]{view_step()}} the standard version
will look at the data present in the calculated frames and set the ranges
based on that, while the \code{_manual} version will allow you to define your own
ranges to zoom between.
}
\examples{
anim <- ggplot(iris, aes(Petal.Length, Petal.Width, colour = Species)) +
  geom_point() +
  transition_states(Species, transition_length = 2, state_length = 1) +
  shadow_mark(past = TRUE, future = TRUE, colour = 'grey') +
  view_zoom(pause_length = 1, step_length = 2, nsteps = 3)

# Use pan_zoom to change the relationship between pan- and zoom movement
# Mainly zooming
anim1 <- ggplot(iris, aes(Petal.Length, Petal.Width, colour = Species)) +
  geom_point() +
  transition_states(Species, transition_length = 2, state_length = 1) +
  shadow_mark(past = TRUE, future = TRUE, colour = 'grey') +
  view_zoom(pause_length = 1, step_length = 2, nsteps = 3, pan_zoom = -3)

# Mainly panning
anim2 <- ggplot(iris, aes(Petal.Length, Petal.Width, colour = Species)) +
  geom_point() +
  transition_states(Species, transition_length = 2, state_length = 1) +
  shadow_mark(past = TRUE, future = TRUE, colour = 'grey') +
  view_zoom(pause_length = 1, step_length = 2, nsteps = 3, pan_zoom = -3)

}
\references{
Reach, A., North, C. (2018) \emph{Smooth, Efficient, and Interruptible Zooming and Panning}. IEEE Transactions on Visualization and Computer Graphics DOI:10.1109/TVCG.2018.2800013
}
\seealso{
Other views: \code{\link{view_follow}},
  \code{\link{view_static}}, \code{\link{view_step}}
}
\concept{views}
