% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_col.R
\name{gg_col}
\alias{gg_col}
\title{Col ggplot.}
\usage{
gg_col(
  data = NULL,
  x = NULL,
  y = NULL,
  col = NULL,
  facet = NULL,
  facet2 = NULL,
  group = NULL,
  text = NULL,
  stat = "identity",
  position = "stack",
  pal = NULL,
  pal_na = "#7F7F7F",
  alpha = 0.9,
  width = NULL,
  ...,
  titles = NULL,
  title = NULL,
  subtitle = NULL,
  coord = NULL,
  x_breaks = NULL,
  x_expand = NULL,
  x_include = NULL,
  x_labels = NULL,
  x_limits = NULL,
  x_oob = scales::oob_keep,
  x_sec_axis = ggplot2::waiver(),
  x_title = NULL,
  x_trans = "identity",
  y_breaks = NULL,
  y_expand = NULL,
  y_include = NULL,
  y_labels = NULL,
  y_limits = NULL,
  y_oob = scales::oob_keep,
  y_sec_axis = ggplot2::waiver(),
  y_title = NULL,
  y_trans = "identity",
  col_breaks = NULL,
  col_include = NULL,
  col_intervals = NULL,
  col_labels = NULL,
  col_legend_place = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_limits = NULL,
  col_title = NULL,
  facet_labels = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_scales = "fixed",
  caption = NULL,
  theme = NULL
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{x}{Unquoted x aesthetic variable.}

\item{y}{Unquoted y aesthetic variable.}

\item{col}{Unquoted col and fill aesthetic variable.}

\item{facet}{Unquoted facet aesthetic variable.}

\item{facet2}{Unquoted second facet variable for a facet grid of facet by facet2 variables.}

\item{group}{Unquoted group aesthetic variable.}

\item{text}{Unquoted text aesthetic variable, which can be used in combination with plotly::ggplotly(., tooltip = "text").}

\item{stat}{Statistical transformation. A character string (e.g. "identity").}

\item{position}{Position adjustment. Either a character string (e.g."identity"), or a function (e.g. ggplot2::position_identity()).}

\item{pal}{Colours to use. A character vector of hex codes (or names).}

\item{pal_na}{Colour to use for NA values. A character vector of a hex code (or name).}

\item{alpha}{Opacity. A number between 0 and 1.}

\item{width}{Width. A number 0 upwards.}

\item{...}{Other arguments passed to the relevant ggplot2::geom_* function.}

\item{titles}{A function to format the x, y and col titles, including in rlang lambda format. Defaults to snakecase::to_sentence_case.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{coord}{Coordinate system.}

\item{x_breaks}{A function that takes the limits as input (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{x_expand}{Padding to the limits with the ggplot2::expansion function, or a vector of length 2 (e.g. c(0, 0)).}

\item{x_include}{For a numeric or date variable, any values that the scale should include (e.g. 0).}

\item{x_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels.}

\item{x_limits}{A vector of length 2 to determine the limits of the axis.}

\item{x_oob}{A scales::oob_* function for how to deal with out-of-bounds values.}

\item{x_sec_axis}{A secondary axis specified by the ggplot2::sec_axis or ggplot2::dup_axis function.}

\item{x_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{x_trans}{For a numeric variable, a transformation object (e.g. "log10").}

\item{y_breaks}{A function that takes the limits as input (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{y_expand}{Padding to the limits with the ggplot2::expansion function, or a vector of length 2 (e.g. c(0, 0)).}

\item{y_include}{For a numeric or date variable, any values that the scale should include (e.g. 0).}

\item{y_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels.}

\item{y_limits}{A vector of length 2 to determine the limits of the axis.}

\item{y_oob}{A scales::oob_* function for how to deal with out-of-bounds values.}

\item{y_sec_axis}{A secondary axis specified by the ggplot2::sec_axis or ggplot2::dup_axis function.}

\item{y_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{y_trans}{For a numeric variable, a transformation object (e.g. "log10").}

\item{col_breaks}{A function that takes the limits as input (e.g. scales::breaks_pretty()), or a vector of breaks.}

\item{col_include}{For a numeric or date variable, any values that the scale should include (e.g. 0).}

\item{col_intervals}{A function to cut or chop the numeric variable into intervals (e.g. ~ santoku::chop_mean_sd(.x, drop = FALSE)).}

\item{col_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a vector of labels. Note this does not affect where col_intervals is not NULL.}

\item{col_legend_place}{The place for the legend. "b" for bottom, "r" for right, "t" for top, or "l" for left.}

\item{col_legend_ncol}{The number of columns for the legend elements.}

\item{col_legend_nrow}{The number of rows for the legend elements.}

\item{col_limits}{A vector to determine the limits of the axis.}

\item{col_title}{Axis title string. Defaults to converting to sentence case with spaces. Use "" for no title.}

\item{facet_labels}{A function that takes the breaks as inputs (e.g. scales::label_comma()), or a named vector of labels (e.g. c(value = "label", ...)).}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string.}

\item{theme}{A ggplot2 theme.}
}
\value{
A ggplot object.
}
\description{
Create a col plot with a wrapper around the ggplot2::geom_col function.
}
\examples{
df <- data.frame(trt = c("a", "b", "c"), outcome = c(2.3, 1.9, 3.2))
gg_col(df, x = trt, y = outcome)
gg_col(df, x = trt, y = outcome, col = trt)

}
