% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_theme.R
\name{gg_theme}
\alias{gg_theme}
\title{Quick theme for a ggplot}
\usage{
gg_theme(
  text_family = "",
  text_size = 10,
  text_pal = "#323232",
  text_face = "plain",
  title_size = text_size + 1,
  title_pal = "#000000",
  title_face = "bold",
  title_vjust = text_size * 0.2,
  title_margin = ggplot2::margin(t = text_size * -0.5, b = text_size * 1.25),
  subtitle_size = text_size,
  subtitle_pal = "#323232",
  subtitle_face = "plain",
  subtitle_vjust = text_size * 0.4,
  subtitle_margin = ggplot2::margin(t = text_size * -0.5, b = text_size),
  caption_size = text_size - 1,
  caption_pal = "#7F7F7F",
  caption_face = "plain",
  caption_hjust = 0,
  axis_line_linewidth = 0.3,
  axis_line_pal = "#323232",
  axis_ticks_linewidth = NULL,
  axis_ticks_pal = NULL,
  legend_key_pal = NULL,
  panel_background_pal = "#FEFEFE",
  panel_grid_linewidth = 0.2,
  panel_grid_pal = "#D3D3D3",
  panel_spacing_lines = 1.25,
  plot_background_pal = "#F1F3F5"
)
}
\arguments{
\item{text_family}{The font family for all text to use. Defaults to "".}

\item{text_size}{The size of all text other than the title, subtitle and caption. Defaults to 10.}

\item{text_pal}{The colour for all text other than the title, subtitle or caption. Defaults to "#323232".}

\item{text_face}{The font style of all text other than the title, subtitle or caption. Defaults to "plain".}

\item{title_size}{The size of the title text_family. Defaults to 11.}

\item{title_pal}{The colour for the title text_family. Defaults to "#000000".}

\item{title_face}{The font style of the title text_family. Defaults to "bold".}

\item{title_vjust}{The vertical adjustment for the title.}

\item{title_margin}{The margin for the title.}

\item{subtitle_size}{The size of the subtitle text_family. Defaults to 10.}

\item{subtitle_pal}{The colour for the subtitle text_family. Defaults to "#323232".}

\item{subtitle_face}{The font style of the subtitle text_family. Defaults to "plain".}

\item{subtitle_vjust}{The vertical adjustment for the subtitle.}

\item{subtitle_margin}{The margin for the title.}

\item{caption_size}{The size of the caption. Defaults to 9.}

\item{caption_pal}{The colour for the caption. Defaults to "#7F7F7F".}

\item{caption_face}{The font style of the caption. Defaults to "plain".}

\item{caption_hjust}{The horizontal adjustment for the caption.}

\item{axis_line_linewidth}{The linewidth of the axis. Defaults to 0.3.}

\item{axis_line_pal}{The colour for the axis. Defaults to "#323232".}

\item{axis_ticks_linewidth}{The linewidth of the ticks. Defaults to 0.3.}

\item{axis_ticks_pal}{The colour for the ticks. Defaults to "#323232".}

\item{legend_key_pal}{The colour for the legend key. Defaults to the plot_background_pal.}

\item{panel_background_pal}{The colour for the panel background colour.}

\item{panel_grid_linewidth}{The linewidth of the vertical major gridlines. Defaults to 0.2.}

\item{panel_grid_pal}{The colour for the vertical major gridlines. Defaults to "#D3D3D3".}

\item{panel_spacing_lines}{The size of the spacing between facet panels in units of "lines". Defaults to 1.25.}

\item{plot_background_pal}{The colour for the plot background colour.}
}
\value{
A ggplot theme.
}
\description{
Quick theme for a ggplot visualisation.
}
