% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbreak.R
\name{scale_x_break}
\alias{scale_x_break}
\alias{scale_y_break}
\title{scale_x_break}
\usage{
scale_x_break(breaks)

scale_y_break(breaks)
}
\arguments{
\item{breaks}{break point}
}
\value{
gg object
}
\description{
Set an axis break point for a 'gg' plot
}
\details{
This scale function set an axis break point for a 'gg' plot. Either 'x' and 'y' axes are supported. The result is still a 'gg' object and user can progressively add layers to it.
}
\examples{
require(ggplot2 )
set.seed(2019-01-19)
d <- data.frame(
  x = 1:20,
  y = c(rnorm(5) + 4, rnorm(5) + 20, rnorm(5) + 5, rnorm(5) + 22)
)

p <- ggplot(d, aes(x, y)) + geom_col()
x <- p+scale_y_break(c(7, 17 ) )
print(x)
}
\author{
Guangchuang Yu
}
