% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_x_break}
\alias{scale_x_break}
\alias{scale_y_break}
\title{scale_x_break}
\usage{
scale_x_break(breaks, scales = "fixed", ticklabels = NULL, expand = TRUE)

scale_y_break(breaks, scales = "fixed", ticklabels = NULL, expand = TRUE)
}
\arguments{
\item{breaks}{break point}

\item{scales}{relative width or height of subplots,
default is "fixed". If scale is 'free', all subplots have
equal width or height. It also can be any number to set
relative width or height compare to first subplot.}

\item{ticklabels}{the axis labels to subplot, default is NULL.}

\item{expand}{default is TRUE, logical or a vector of range expansion constants
used to add some padding around the data to ensure that they
are placed some distance away from the axes. Use the convenience
function \code{expansion()} of \code{ggplot2} to generate the values for
the \code{expand} argument. The defaults are to expand the scale
by 5\% on each side for continuous variables. If it is logical, the \code{TRUE} means
the default of \code{ggplot2} (foregoing statement), and \code{FALSE} means no expand for the plot.}
}
\value{
gg object
}
\description{
Set an axis break point for a 'gg' plot
}
\details{
This scale function set an axis break point for a 'gg' plot. Either 'x' and 'y' axes are supported. The result is still a 'gg' object and user can progressively add layers to it.
}
\examples{
require(ggplot2 )
set.seed(2019-01-19)
d <- data.frame(
  x = 1:20,
  y = c(rnorm(5) + 4, rnorm(5) + 20, rnorm(5) + 5, rnorm(5) + 22)
)

p <- ggplot(d, aes(x, y)) + geom_col()
x <- p+scale_y_break(c(7, 17 ) )
print(x)
}
\author{
Guangchuang Yu
}
