% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lollipop_chart.R
\name{lollipop_chart}
\alias{lollipop_chart}
\title{Lollipop Chart}
\usage{
lollipop_chart(
  data,
  x,
  y,
  facet = NULL,
  ...,
  line_size = 0.75,
  line_color = "#1F77B4",
  point_size = 4,
  point_color = line_color,
  highlight = NULL,
  sort = TRUE,
  horizontal = TRUE,
  limit = NULL,
  threshold = NULL
)
}
\arguments{
\item{data}{Dataset to use for the bar chart}

\item{x}{\code{character} or \code{factor} column of \code{data}}

\item{y}{\code{numeric} column of \code{data} representing the lollipop length}

\item{facet}{\code{character} or \code{factor} column of \code{data} defining
the faceting groups}

\item{...}{Additional arguments passed to \code{aes()}}

\item{line_size}{\code{numeric}. Size of the lollipop 'stick'}

\item{line_color}{\code{character}. Color of the lollipop 'stick'}

\item{point_size}{\code{numeric}. Size of the lollipop 'head'}

\item{point_color}{\code{character}. Color of the lollipop 'head'}

\item{highlight}{\code{character}. One or more value(s) of \code{x} that
should be highlighted in the plot}

\item{sort}{\code{logical}. Should the data be sorted before plotting?}

\item{horizontal}{\code{logical}. Should the plot be oriented horizontally?}

\item{limit}{\code{numeric}. If a value for \code{limit} is provided only the
top \code{limit} records will be displayed}

\item{threshold}{\code{numeric}. If a value for threshold is provided only
records with \code{y > threshold} will be displayed}
}
\value{
An object of class \code{ggplot}
}
\description{
Easily create a lollipop chart
}
\details{
Both \code{limit} and \code{threshold} only work when \code{sort = TRUE}.
Attempting to use them when \code{sort = FALSE} will result in an error.
Furthermore, only \code{limit} or \code{threshold} can be used at a time.
Providing a value for both \code{limit} and \code{threshold} will result in
an error as well.
}
\examples{
data(biomedicalrevenue)
revenue2016 <- biomedicalrevenue[biomedicalrevenue$year == 2016, ]
revenue_bayer <- biomedicalrevenue[biomedicalrevenue$company == "Bayer", ]

## By default lollipop_chart() creates a horizontal and sorted plot
lollipop_chart(revenue2016, company, revenue)

## Create a vertical, non-sorted lollipop chart
lollipop_chart(revenue_bayer, year, revenue, horizontal = FALSE, sort = FALSE)

## Limit the number of lollipops to the top 15
lollipop_chart(revenue2016, company, revenue, limit = 15)

## Display only companies with revenue > 50B.
lollipop_chart(revenue2016, company, revenue, threshold = 50)

## Change the color of the whole lollipop
lollipop_chart(revenue2016, company, revenue, line_color = "purple")

## Change the color of the lollipop stick and head individually
lollipop_chart(revenue2016, company, revenue, point_color = "darkgreen", line_color = "gray")

## Decrease the lollipop head size
lollipop_chart(revenue2016, company, revenue, point_size = 2.5)

## Highlight a single lollipop
lollipop_chart(revenue2016, company, revenue, limit = 15, highlight = "Roche")

## Use facets to show the top 10 companies over the years
lollipop_chart(biomedicalrevenue, company, revenue, facet = year, limit = 10)

}
\author{
Thomas Neitmann
}
