% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_sa.R
\name{geom_sa}
\alias{geom_sa}
\alias{stat_sa}
\title{Seasonal adjustment time series}
\usage{
geom_sa(
  mapping = NULL,
  data = NULL,
  stat = "sa",
  position = "identity",
  ...,
  method = c("x13", "tramoseats"),
  spec = NULL,
  frequency = NULL,
  message = TRUE,
  component = "sa",
  show.legend = NA,
  inherit.aes = TRUE
)

stat_sa(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  ...,
  method = c("x13", "tramoseats"),
  spec = NULL,
  frequency = NULL,
  message = TRUE,
  component = "sa",
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \link[ggplot2:aes]{aes()} or
\link[ggplot2:aes_]{aes_()}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{A \code{data.frame} that contains the data used for the seasonal adjustment.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \link[ggplot2:layer]{layer()}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}.}

\item{method}{the method used for the seasonal adjustment. \code{"x13"} (by default) for the X-13ARIMA method and \code{"tramoseats"} for TRAMO-SEATS.}

\item{spec}{the specification used for the seasonal adjustment.
See \link[RJDemetra:x13]{x13()} or \link[RJDemetra:tramoseats]{tramoseats()}.}

\item{frequency}{the frequency of the time series. By default (\code{frequency = NULL}),
the frequency is computed automatically.}

\item{message}{a \code{boolean} indicating if a message is printed with the frequency used.}

\item{component}{a \code{character} equals to the component to plot. The result must be a time series.
See \link[RJDemetra:user_defined_variables]{user_defined_variables()} for the available
parameters. By default (\code{component = 'sa'}) the seasonal adjusted component is plotted.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them.}

\item{geom}{The geometric object to use to display the data}
}
\description{
Performs a seasonal adjustment and plots a time seriesAids the eye in seeing patterns in the presence of overplotting. \code{geom_sa()} and \code{stat_sa()} are  aliases: they both use the same arguments. Use \code{stat_sa()} if you want to display the results with a non-standard geom.
}
\examples{
p_ipi_fr <- ggplot(data = ipi_c_eu_df, mapping = aes(x = date, y = FR)) +
    geom_line() +
    labs(title = "Seasonal adjustment of the French industrial production index",
         x = "time", y = NULL)

# To add the seasonal adjusted series:
p_ipi_fr +
    geom_sa(color = "red")

# To add the forecasts of the input data and the seasonal adjusted series:
p_sa <- p_ipi_fr +
    geom_sa(component = "y_f", linetype = 2, message = FALSE) + 
    geom_sa(component = "sa", color = "red", message = FALSE) +
    geom_sa(component = "sa_f", color = "red", linetype = 2, message = FALSE)
p_sa 
}
