% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_ggdist.R
\name{theme_ggdist}
\alias{theme_ggdist}
\alias{theme_tidybayes}
\alias{facet_title_horizontal}
\alias{axis_titles_bottom_left}
\alias{facet_title_left_horizontal}
\alias{facet_title_right_horizontal}
\title{Simple, light ggplot2 theme for ggdist and tidybayes}
\usage{
theme_ggdist(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_tidybayes(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

facet_title_horizontal()

axis_titles_bottom_left()

facet_title_left_horizontal()

facet_title_right_horizontal()
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\value{
A named list in the format of \code{\link[ggplot2:theme]{ggplot2::theme()}}
}
\description{
A simple, relatively minimalist ggplot2 theme, and some helper functions to go with it.
}
\details{
This is a relatively minimalist ggplot2 theme, intended to be used for making publication-ready plots.
It is currently based on \code{\link[ggplot2:ggtheme]{ggplot2::theme_light()}}.

A word of warning: this theme may (and very likely will) change in the future as I tweak it to my taste.

\code{\link[=theme_ggdist]{theme_ggdist()}} and \code{\link[=theme_tidybayes]{theme_tidybayes()}} are aliases.
}
\examples{

library(ggplot2)

theme_set(theme_ggdist())

}
\seealso{
\code{\link[ggplot2:theme]{ggplot2::theme()}}, \code{\link[ggplot2:theme_get]{ggplot2::theme_set()}}
}
\author{
Matthew Kay
}
