% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_sampling.R
\name{run.dmc}
\alias{run.dmc}
\title{run function}
\usage{
run.dmc(samples, report = 100, cores = 1, p.migrate = 0,
  gamma.mult = 2.38, farjump = NA, force = FALSE, setting = NULL,
  verbose = FALSE, debug = FALSE)
}
\arguments{
\item{samples}{a sample list generated by calling DMC's samples.dmc.
You can also use ggdmc's own initialise to generate a samples.}

\item{report}{how many iterations to return a report}

\item{cores}{a switch for computing the prob density for each trial in
parallel. Turn it on by setting any number > 1.}

\item{p.migrate}{set it greater than 0 to use migration samplers. For example
p.migrate=0.05 will use migration in 5\% chance.}

\item{gamma.mult}{a DEMC tuning parameter, affecting the size of jump}

\item{farjump}{No funciton for compatibility reason}

\item{force}{No funciton for compatibility reason}

\item{setting}{a list run setting arguments, such as p.migrate, gamma.mult,
report and cores, send to C++ function.}

\item{verbose}{Turn it on to print loads of debugging informatoin}

\item{debug}{default as FALSE to use random chain sequence. TRUE uses ordered
chain sequence.}
}
\value{
a DMC sample
}
\description{
a wrapper function calls run_data C++ function to do hierarchical Bayesian
sampling. It selects data-level or hyper-level sampling by looking for
hyper attribute and the numbers of participants in a sample list.
}
\examples{
m1 <- model.dmc(
    p.map     = list(a="1",v="1",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
    constants = c(st0=0, d=0),
    match.map = list(M=list(s1="r1", s2="r2")),
    factors   = list(S=c("s1", "s2")),
    responses = c("r1", "r2"),
    type      = "rd")

## Use 6 prior truncated normal distributions
p.prior <- prior.p.dmc(
  dists = rep("tnorm", 6),
  p1    = c(a=2,  v=2.5, z=.5, sz=.3, sv=1,  t0=.3),
  p2    = c(a=.5, v=.5,  z=.1, sz=.1, sv=.3, t0=.05),
  lower = c(0,-5, 0, 0, 0, 0),
  upper = c(5, 7, 2, 2, 2, 2))

## parameter vector. These are the trun values simulating data
p.vector <- c(a=1,v=1, z=.5, sz=.25, sv=.2,t0=.15)
dat1 <- simulate(m1, nsim=1e2, p.vector=p.vector)
mdi1 <- data.model.dmc(dat1, m1)

## Use DMC's plot_cell_density to examine distributions
## Accuracy around 70\%
par(mfrow=c(1,2))
plot_cell_density(data.cell=mdi1[mdi1$S=="s1", ], C="r1", xlim=c(0,2))
plot_cell_density(data.cell=mdi1[mdi1$S=="s2", ], C="r2", xlim=c(0,2))
par(mfrow=c(1,1))

## ---------------------------
## Profiles all 6 parameters
par(mfrow=c(2,3));
profile(mdi1, "a",  .1,  2, p.vector)
profile(mdi1, "v",  .1,  2, p.vector)
profile(mdi1, "z",  .2, .8, p.vector)
profile(mdi1, "sz", .1, .9, p.vector)
profile(mdi1, "sv", .1,  2, p.vector)
profile(mdi1, "t0", .01, .5, p.vector)
par(mfrow=c(1,1));

## Initialse a DMC sample
## nthin == 1 (default)
## niter == 100
## prior distributions as listed in p.prior
## data  == model data instance 1
## do not use migrate sampler (default p.migrate=0)
samples0 <- samples.dmc(nmc=20, p.prior=p.prior, data=mdi1)
samples0 <- run.dmc(samples0)
}

