% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\docType{data}
\name{ggedit_opts}
\alias{ggedit_opts}
\alias{ggedit_opts_current}
\title{Default and current ggedit options}
\format{
An object of class \code{list} of length 5.

An object of class \code{list} of length 5.
}
\usage{
ggedit_opts

ggedit_opts_current
}
\description{
Options for functions in the ggedit package. When running R code, the object \code{ggedit_opts}
(default options) is not modified by chunk headers (local chunk options are
merged with default options), whereas \code{ggedit_opts_current} (current options)
changes with different chunk headers and it always reflects the options for
the current chunk.

Normally we set up the global options once in the first code chunk in a
document using \code{ggedit_opts$set()}, so that all \emph{latter} chunks will
use these options. Note the global options set in one chunk will not affect
the options in this chunk itself, and that is why we often need to set global
options in a separate chunk.
}
\note{
\code{ggedit_opts_current} is read-only in the sense that it does nothing if
  you call \code{ggedit_opts_current$set()}; you can only query the options via
  \code{ggedit_opts_current$get()}.
}
\examples{
ggedit_opts$get('themeDefaultClass')
}
\keyword{datasets}
