% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotDegMatrix}
\alias{plotDegMatrix}
\title{Returns the image object to show the heat map of degrees between the inputted set of vertices}
\usage{
plotDegMatrix(varieties, ig, geneal, xLab = "Variety", yLab = "Variety",
  legendLab = "Degree")
}
\arguments{
\item{varieties}{subset of varieties used to generate the heat map}

\item{ig}{the graph representation of the data genealogy (in igraph format)}

\item{geneal}{the full genealogy  (in data frame format)}

\item{xLab}{string label on the x axis (default is "Variety")}

\item{yLab}{string label on the y axis (default is "Variety")}

\item{legendLab}{string label on the legend (default is "Degree")}
}
\description{
Returns the image object to show the heat map of degrees between the inputted set of vertices
}
\examples{
data(sbGeneal)
ig <- dfToIG(sbGeneal)
varieties <- c("Bedford", "Calland", "Narow", "Pella", "Tokyo", "Young", "Zane")
p <- plotDegMatrix(varieties, ig, sbGeneal, "Soybean label", "Soybean label", "Degree")
p + ggplot2::scale_fill_continuous(low = "white", high = "darkgreen")

}
\seealso{
\url{http://www.r-project.org} for iGraph information
}

