% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotPathOnAll}
\alias{plotPathOnAll}
\title{Plot a path between two vertices over the full genealogy}
\usage{
plotPathOnAll(path, geneal, ig, binVector = sample(1:12, 12),
  edgeCol = "gray84", pathEdgeCol = "seagreen", nodeSize = 3,
  pathNodeSize = 3, pathNodeFont = "bold", nodeCol = "black",
  animate = FALSE)
}
\arguments{
\item{path}{path as returned from getPath() or a vector of two variety names which exist in ig}

\item{geneal}{the full genealogy  (in data frame format)}

\item{ig}{the graph representation of the data genealogy (in igraph format)}

\item{binVector}{vector of numbers between 1 and length(binVector), each repeated exactly once}

\item{edgeCol}{color of the non-path edges, default is "gray84"}

\item{pathEdgeCol}{color of the path edges, default is "seagreen"}

\item{nodeSize}{text size of the non-path node labels, default is 3}

\item{pathNodeSize}{text size of the path node labels, default is 3}

\item{pathNodeFont}{font face of text of the path node labels ("plain", "italic", "bold", "bold.italic"), default is "bold"}

\item{nodeCol}{color of the non-path node labels, default is black}

\item{animate}{If the plot will have interactive capabilities, default is FALSE}
}
\description{
This function requires a path and the ig object, and plots the full genealogy 
with the path highlighted.
The image will correctly position the node labels with x-axis representing the node
year, and y-axis representing the node path index. Light grey edges between two nodes
represent parent-child relationships between those nodes. To enhance the visual
understanding of how the path-of-interest fits into the entire graph structure, the
nodes within the path are labelled in boldface, and connected with light-green
boldfaced edges.
}
\examples{
data(sbGeneal)
ig <- dfToIG(sbGeneal)
path <- getPath("Brim", "Bedford", ig, sbGeneal)
bV <- sample(1:12, 12)
plotTotalImage <- plotPathOnAll(path = path, geneal = sbGeneal, ig = ig, binVector = bV)
plotTotalImage
}
\seealso{
\url{http://www.r-project.org} for iGraph information

\code{\link{getPath}} for information on input path building
}

