% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{plotYearMatrix}
\alias{plotYearMatrix}
\title{Returns the image object to show the heat map of years between the inputted set of vertices}
\usage{
plotYearMatrix(varieties, geneal, xLab = "Variety", yLab = "Variety",
  legendLab = "Difference in years")
}
\arguments{
\item{varieties}{subset of varieties used to generate the heat map}

\item{geneal}{the full genealogy  (in data frame format)}

\item{xLab}{string label on the x axis (default is "Variety")}

\item{yLab}{string label on the y axis (default is "Variety")}

\item{legendLab}{string label on the legend (default is "Degree")}
}
\description{
Returns the image object to show the heat map of years between the inputted set of vertices
}
\examples{
data(sbGeneal)
varieties <- c("Bedford", "Calland", "Narow", "Pella", "Tokyo", "Young", "Zane")
p <- plotYearMatrix(varieties, sbGeneal, "Variety", "Variety", "Degree")
p + ggplot2::scale_fill_continuous(low = "white", high = "darkgreen")

}

